## TFSA-2021-163: Null pointer dereference in TFLite MLIR optimizations

### CVE Number
CVE-2021-37689

### Impact
An attacker can craft a TFLite model that would trigger a null pointer
dereference, which would result in a crash and denial of service:

This is caused by the MLIR optimization of `L2NormalizeReduceAxis` operator. The
[implementation](https://github.com/tensorflow/tensorflow/blob/149562d49faa709ea80df1d99fc41d005b81082a/tensorflow/compiler/mlir/lite/transforms/optimize.cc#L67-L70)
unconditionally dereferences a pointer to an iterator to a vector without
checking that the vector has elements:

```cc
bool L2NormalizeReduceAxis(Value sq_op, DenseElementsAttr axis) {
  if (sq_op.getType().cast<ShapedType>().getRank() - 1 ==
          *axis.getValues<int>().begin() ||
      *axis.getValues<int>().begin() == -1) {
      // ...
  }
  // ...
}
```

### Patches
We have patched the issue in GitHub commit
[d6b57f461b39fd1aa8c1b870f1b974aac3554955](https://github.com/tensorflow/tensorflow/commit/d6b57f461b39fd1aa8c1b870f1b974aac3554955).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Yakun Zhang of Baidu Security.
