/*
 * ligand/chi-angles-autogen.cc
 *
 * Copyright 2007 by University of York
 * Author: Paul Emsley
 *
 * This file is part of Coot
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copies of the GNU General Public License and
 * the GNU Lesser General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA, 02110-1301, USA.
 * See http://www.gnu.org/licenses/
 *
 */
 
#include "chi-angles.hh" 
 
void
coot::chi_angles::add_all_rotamers() { 
 
      add_rotamer (std::string("ARG"), 1, 1, 1, 1, 568, 2, 0.04, 0.02, 0.41, 0.22, 55.4, 19.8, 79.7, 16.1, 62.4, 15.0, 82.3, 11.9);
      add_rotamer (std::string("ARG"), 1, 1, 1, 2, 568, 5, 0.07, 0.03, 0.83, 0.31, 59.2, 23.2, 85.4, 16.6, 68.2, 15.4, -166.2, 25.4);
      add_rotamer (std::string("ARG"), 1, 1, 1, 3, 568, 0, 0.00, 0.01, 0.04, 0.07, 54.5, 21.5, 79.4, 17.2, 64.6, 16.6, -103.2, 12.5);
      add_rotamer (std::string("ARG"), 1, 1, 2, 1, 568, 3, 0.05, 0.02, 0.56, 0.26, 54.5, 19.0, 86.6, 13.0, 178.2, 13.1, 85.5, 12.6);
      add_rotamer (std::string("ARG"), 1, 1, 2, 2, 568, 9, 0.13, 0.04, 1.49, 0.42, 53.9, 18.9, 87.8, 13.9, -178.5, 18.0, 178.1, 22.0);
      add_rotamer (std::string("ARG"), 1, 1, 2, 3, 568, 4, 0.06, 0.03, 0.73, 0.29, 53.5, 20.2, 87.8, 11.8, -176.0, 17.5, -81.1, 12.2);
      add_rotamer (std::string("ARG"), 1, 1, 3, 1, 568, 0, 0.00, 0.00, 0.01, 0.04, 54.5, 21.5, 83.5, 14.5, -78.4, 20.8, 102.9, 14.2);
      add_rotamer (std::string("ARG"), 1, 1, 3, 2, 568, 2, 0.03, 0.02, 0.29, 0.18, 50.0, 23.4, 82.4, 13.6, -92.5, 15.5, 169.0, 21.6);
      add_rotamer (std::string("ARG"), 1, 1, 3, 3, 568, 0, 0.00, 0.01, 0.04, 0.07, 54.5, 21.5, 83.5, 14.5, -77.1, 19.2, -84.1, 10.7);
      add_rotamer (std::string("ARG"), 1, 2, 1, 1, 568, 35, 0.62, 0.08, 7.05, 0.88, 62.0, 14.2, 177.8, 15.7, 64.9, 12.0, 84.4, 12.2);
      add_rotamer (std::string("ARG"), 1, 2, 1, 2, 568, 70, 1.09, 0.11, 12.40, 1.13, 64.1, 10.6, -175.8, 15.2, 68.0, 15.3, -172.6, 22.0);
      add_rotamer (std::string("ARG"), 1, 2, 1, 3, 568, 12, 0.19, 0.04, 2.15, 0.50, 65.1, 9.4, -178.6, 11.3, 61.1, 13.6, -104.5, 10.5);
      add_rotamer (std::string("ARG"), 1, 2, 2, 1, 568, 104, 1.36, 0.12, 15.48, 1.24, 65.3, 9.0, 180.0, 11.2, 178.0, 13.7, 85.7, 11.8);
      add_rotamer (std::string("ARG"), 1, 2, 2, 2, 568, 110, 1.74, 0.13, 19.82, 1.36, 66.5, 11.2, -177.6, 13.9, -178.9, 13.0, -177.2, 21.2);
      add_rotamer (std::string("ARG"), 1, 2, 2, 3, 568, 94, 1.34, 0.12, 15.19, 1.23, 66.4, 9.1, -175.2, 12.6, -177.5, 11.9, -82.5, 15.2);
      add_rotamer (std::string("ARG"), 1, 2, 3, 1, 568, 8, 0.16, 0.04, 1.86, 0.46, 63.8, 13.0, -171.9, 17.8, -64.5, 16.4, 102.9, 11.6);
      add_rotamer (std::string("ARG"), 1, 2, 3, 2, 568, 64, 1.03, 0.10, 11.69, 1.10, 63.4, 11.4, -176.5, 14.2, -66.7, 13.7, 173.2, 22.5);
      add_rotamer (std::string("ARG"), 1, 2, 3, 3, 568, 27, 0.58, 0.08, 6.63, 0.85, 62.9, 10.6, 179.9, 15.6, -69.2, 13.0, -82.5, 12.8);
      add_rotamer (std::string("ARG"), 1, 3, 1, 1, 568, 1, 0.01, 0.01, 0.15, 0.13, 65.2, 23.2, -85.1, 20.9, 84.2, 18.8, 84.5, 13.8);
      add_rotamer (std::string("ARG"), 1, 3, 1, 2, 568, 1, 0.01, 0.01, 0.16, 0.14, 63.2, 22.7, -85.5, 21.4, 80.7, 19.3, -172.0, 22.0);
      add_rotamer (std::string("ARG"), 1, 3, 1, 3, 568, 0, 0.00, 0.00, 0.01, 0.03, 63.6, 23.8, -82.1, 19.5, 71.6, 19.4, -103.2, 12.5);
      add_rotamer (std::string("ARG"), 1, 3, 2, 1, 568, 0, 0.01, 0.01, 0.14, 0.13, 63.6, 23.8, -78.2, 18.9, -179.8, 16.6, 85.7, 14.3);
      add_rotamer (std::string("ARG"), 1, 3, 2, 2, 568, 5, 0.08, 0.03, 0.89, 0.32, 57.6, 25.1, -83.1, 19.9, -176.1, 13.8, -178.4, 21.2);
      add_rotamer (std::string("ARG"), 1, 3, 2, 3, 568, 4, 0.06, 0.02, 0.65, 0.28, 68.7, 21.8, -75.7, 16.5, -177.8, 8.5, -85.7, 13.1);
      add_rotamer (std::string("ARG"), 1, 3, 3, 1, 568, 0, 0.00, 0.01, 0.04, 0.07, 63.6, 23.8, -77.9, 19.7, -77.1, 21.6, 102.9, 14.2);
      add_rotamer (std::string("ARG"), 1, 3, 3, 2, 568, 6, 0.08, 0.03, 0.90, 0.32, 63.7, 23.4, -78.1, 19.1, -64.2, 11.7, 169.9, 22.2);
      add_rotamer (std::string("ARG"), 1, 3, 3, 3, 568, 2, 0.04, 0.02, 0.40, 0.22, 63.8, 22.0, -78.2, 18.5, -59.5, 9.1, -83.3, 10.3);
      add_rotamer (std::string("ARG"), 2, 1, 1, 1, 2087, 42, 0.64, 0.08, 1.96, 0.25, -176.5, 13.7, 65.8, 12.2, 60.2, 12.7, 80.8, 15.8);
      add_rotamer (std::string("ARG"), 2, 1, 1, 2, 2087, 61, 0.92, 0.10, 2.83, 0.30, 179.4, 11.3, 65.8, 11.5, 65.3, 11.5, -170.9, 18.6);
      add_rotamer (std::string("ARG"), 2, 1, 1, 3, 2087, 5, 0.10, 0.03, 0.32, 0.10, -173.6, 13.0, 68.1, 11.0, 67.3, 18.7, -103.0, 11.8);
      add_rotamer (std::string("ARG"), 2, 1, 2, 1, 2087, 63, 0.89, 0.10, 2.77, 0.29, 179.3, 9.2, 66.2, 11.3, -178.6, 8.4, 85.1, 12.0);
      add_rotamer (std::string("ARG"), 2, 1, 2, 2, 2087, 95, 1.49, 0.12, 4.62, 0.38, -177.0, 11.6, 67.4, 14.0, 177.0, 16.0, 171.0, 20.7);
      add_rotamer (std::string("ARG"), 2, 1, 2, 3, 2087, 41, 0.73, 0.09, 2.27, 0.27, 178.1, 10.9, 66.9, 10.9, -178.7, 10.8, -85.3, 12.4);
      add_rotamer (std::string("ARG"), 2, 1, 3, 1, 2087, 1, 0.02, 0.02, 0.07, 0.05, -176.1, 14.0, 81.2, 15.7, -80.9, 21.4, 103.3, 13.6);
      add_rotamer (std::string("ARG"), 2, 1, 3, 2, 2087, 21, 0.28, 0.05, 0.86, 0.16, -175.6, 15.8, 79.6, 16.3, -90.4, 17.2, 172.4, 22.2);
      add_rotamer (std::string("ARG"), 2, 1, 3, 3, 2087, 6, 0.11, 0.03, 0.35, 0.11, -178.7, 9.9, 78.6, 13.2, -78.3, 15.9, -84.6, 11.1);
      add_rotamer (std::string("ARG"), 2, 2, 1, 1, 2087, 217, 3.08, 0.18, 9.52, 0.52, -177.3, 9.5, 178.6, 14.7, 64.9, 13.3, 80.8, 12.5);
      add_rotamer (std::string("ARG"), 2, 2, 1, 2, 2087, 240, 3.67, 0.19, 11.34, 0.57, -174.1, 13.6, 176.8, 16.7, 67.8, 13.7, -167.7, 22.5);
      add_rotamer (std::string("ARG"), 2, 2, 1, 3, 2087, 73, 0.96, 0.10, 2.98, 0.30, -176.7, 13.1, 178.8, 15.2, 63.4, 16.4, -103.7, 10.3);
      add_rotamer (std::string("ARG"), 2, 2, 2, 1, 2087, 154, 2.52, 0.16, 7.80, 0.48, -176.8, 10.2, 177.6, 11.8, 178.8, 15.4, 85.2, 13.7);
      add_rotamer (std::string("ARG"), 2, 2, 2, 2, 2087, 339, 5.46, 0.23, 16.90, 0.67, -176.9, 9.6, 176.3, 11.3, 178.8, 14.1, -179.4, 21.4);
      add_rotamer (std::string("ARG"), 2, 2, 2, 3, 2087, 195, 3.19, 0.18, 9.88, 0.53, -177.5, 9.6, 176.5, 10.8, -177.8, 11.7, -85.2, 11.6);
      add_rotamer (std::string("ARG"), 2, 2, 3, 1, 2087, 91, 1.20, 0.11, 3.71, 0.34, -174.4, 14.8, 178.1, 12.8, -63.4, 19.3, 105.1, 13.3);
      add_rotamer (std::string("ARG"), 2, 2, 3, 2, 2087, 196, 3.21, 0.18, 9.93, 0.53, -175.4, 14.5, 179.7, 17.5, -64.8, 16.7, 165.2, 23.7);
      add_rotamer (std::string("ARG"), 2, 2, 3, 3, 2087, 188, 2.92, 0.17, 9.05, 0.51, -175.6, 11.4, 179.6, 11.9, -65.0, 12.1, -82.6, 10.8);
      add_rotamer (std::string("ARG"), 2, 3, 1, 1, 2087, 0, 0.01, 0.01, 0.03, 0.03, -169.7, 19.6, -83.6, 16.7, 80.9, 16.4, 82.5, 12.8);
      add_rotamer (std::string("ARG"), 2, 3, 1, 2, 2087, 1, 0.02, 0.02, 0.07, 0.05, -166.0, 22.1, -82.2, 16.5, 78.0, 18.7, -172.4, 22.4);
      add_rotamer (std::string("ARG"), 2, 3, 1, 3, 2087, 0, 0.00, 0.00, 0.01, 0.01, -169.7, 19.6, -83.6, 16.7, 71.6, 19.4, -103.2, 12.5);
      add_rotamer (std::string("ARG"), 2, 3, 2, 1, 2087, 3, 0.07, 0.03, 0.22, 0.08, -171.4, 17.6, -85.4, 10.5, -174.0, 19.3, 84.2, 13.5);
      add_rotamer (std::string("ARG"), 2, 3, 2, 2, 2087, 16, 0.25, 0.05, 0.77, 0.16, -171.3, 19.4, -87.2, 12.2, -179.0, 15.0, -176.1, 16.1);
      add_rotamer (std::string("ARG"), 2, 3, 2, 3, 2087, 8, 0.13, 0.04, 0.41, 0.11, -171.0, 15.3, -84.3, 11.6, -176.8, 9.2, -81.1, 11.9);
      add_rotamer (std::string("ARG"), 2, 3, 3, 1, 2087, 3, 0.04, 0.02, 0.13, 0.07, -170.0, 17.5, -92.9, 16.3, -72.5, 21.3, 104.0, 12.6);
      add_rotamer (std::string("ARG"), 2, 3, 3, 2, 2087, 21, 0.27, 0.05, 0.84, 0.16, -170.2, 21.5, -91.1, 15.0, -67.4, 13.7, 170.0, 22.7);
      add_rotamer (std::string("ARG"), 2, 3, 3, 3, 2087, 7, 0.12, 0.03, 0.36, 0.11, -165.9, 19.0, -84.4, 17.4, -59.4, 10.4, -82.3, 10.5);
      add_rotamer (std::string("ARG"), 3, 1, 1, 1, 3802, 9, 0.15, 0.04, 0.26, 0.07, -79.0, 15.9, 87.7, 20.1, 66.3, 21.7, 84.2, 12.8);
      add_rotamer (std::string("ARG"), 3, 1, 1, 2, 3802, 17, 0.26, 0.05, 0.44, 0.09, -83.1, 21.5, 81.9, 22.3, 69.8, 15.1, -178.0, 22.8);
      add_rotamer (std::string("ARG"), 3, 1, 1, 3, 3802, 1, 0.02, 0.02, 0.04, 0.03, -80.8, 17.2, 86.2, 21.5, 67.4, 18.2, -101.7, 12.9);
      add_rotamer (std::string("ARG"), 3, 1, 2, 1, 3802, 7, 0.14, 0.04, 0.24, 0.06, -78.6, 19.7, 73.8, 15.9, -179.4, 13.6, 85.1, 16.8);
      add_rotamer (std::string("ARG"), 3, 1, 2, 2, 3802, 42, 0.58, 0.08, 0.99, 0.13, -85.8, 12.6, 70.4, 15.8, 174.6, 13.0, 179.0, 23.2);
      add_rotamer (std::string("ARG"), 3, 1, 2, 3, 3802, 17, 0.26, 0.05, 0.45, 0.09, -80.8, 15.4, 79.3, 17.9, 177.3, 13.4, -81.8, 13.9);
      add_rotamer (std::string("ARG"), 3, 1, 3, 1, 3802, 0, 0.00, 0.01, 0.01, 0.01, -82.6, 17.0, 77.9, 17.0, -78.4, 20.8, 102.9, 14.2);
      add_rotamer (std::string("ARG"), 3, 1, 3, 2, 3802, 2, 0.04, 0.02, 0.06, 0.03, -85.1, 16.5, 77.1, 15.6, -91.5, 15.3, 168.7, 22.1);
      add_rotamer (std::string("ARG"), 3, 1, 3, 3, 3802, 1, 0.02, 0.02, 0.04, 0.03, -81.6, 16.5, 78.0, 16.2, -79.6, 20.0, -84.1, 10.7);
      add_rotamer (std::string("ARG"), 3, 2, 1, 1, 3802, 238, 3.92, 0.20, 6.66, 0.33, -66.2, 10.5, 179.5, 12.2, 66.1, 11.4, 84.3, 12.1);
      add_rotamer (std::string("ARG"), 3, 2, 1, 2, 3802, 390, 6.11, 0.24, 10.37, 0.40, -66.7, 12.0, 178.5, 16.5, 65.6, 12.8, -170.1, 21.3);
      add_rotamer (std::string("ARG"), 3, 2, 1, 3, 3802, 50, 0.89, 0.10, 1.50, 0.16, -67.2, 9.7, -178.5, 12.1, 63.1, 19.5, -101.8, 15.4);
      add_rotamer (std::string("ARG"), 3, 2, 2, 1, 3802, 307, 4.80, 0.22, 8.16, 0.36, -66.9, 9.3, 179.7, 13.6, 178.7, 14.6, 86.7, 15.6);
      add_rotamer (std::string("ARG"), 3, 2, 2, 2, 3802, 731, 10.99, 0.32, 18.66, 0.52, -67.7, 9.7, 179.1, 13.3, -179.0, 14.6, 176.3, 21.0);
      add_rotamer (std::string("ARG"), 3, 2, 2, 3, 3802, 383, 6.02, 0.24, 10.23, 0.40, -68.1, 9.6, -179.7, 12.7, -176.3, 13.9, -82.7, 11.9);
      add_rotamer (std::string("ARG"), 3, 2, 3, 1, 3802, 74, 1.22, 0.11, 2.07, 0.19, -68.9, 12.3, -175.6, 9.4, -68.5, 15.4, 102.2, 10.1);
      add_rotamer (std::string("ARG"), 3, 2, 3, 2, 3802, 444, 6.66, 0.25, 11.32, 0.42, -67.0, 9.7, 179.5, 14.4, -67.9, 13.7, 173.2, 22.6);
      add_rotamer (std::string("ARG"), 3, 2, 3, 3, 3802, 350, 5.34, 0.23, 9.06, 0.38, -68.4, 10.6, -170.6, 11.1, -64.5, 13.0, -85.4, 10.5);
      add_rotamer (std::string("ARG"), 3, 3, 1, 1, 3802, 27, 0.38, 0.06, 0.65, 0.11, -63.9, 11.1, -76.1, 14.3, 80.0, 15.3, 79.6, 11.9);
      add_rotamer (std::string("ARG"), 3, 3, 1, 2, 3802, 27, 0.43, 0.07, 0.73, 0.11, -64.3, 11.4, -80.3, 17.9, 78.7, 19.3, -165.9, 21.7);
      add_rotamer (std::string("ARG"), 3, 3, 1, 3, 3802, 3, 0.06, 0.02, 0.10, 0.04, -62.5, 9.3, -80.5, 15.3, 71.6, 17.1, -105.6, 11.9);
      add_rotamer (std::string("ARG"), 3, 3, 2, 1, 3802, 81, 1.33, 0.12, 2.25, 0.20, -62.6, 9.4, -68.9, 12.4, 179.4, 15.8, 83.8, 14.3);
      add_rotamer (std::string("ARG"), 3, 3, 2, 2, 3802, 174, 2.83, 0.17, 4.81, 0.28, -62.7, 8.8, -72.4, 15.0, -177.9, 15.0, -177.8, 20.4);
      add_rotamer (std::string("ARG"), 3, 3, 2, 3, 3802, 169, 2.37, 0.15, 4.02, 0.26, -63.2, 8.0, -69.8, 10.8, -175.2, 8.8, -87.0, 13.2);
      add_rotamer (std::string("ARG"), 3, 3, 3, 1, 3802, 13, 0.28, 0.05, 0.48, 0.09, -64.9, 15.0, -74.5, 15.1, -79.7, 20.6, 95.0, 24.6);
      add_rotamer (std::string("ARG"), 3, 3, 3, 2, 3802, 109, 1.80, 0.14, 3.06, 0.23, -63.6, 12.9, -67.9, 15.2, -65.0, 12.3, 169.4, 22.2);
      add_rotamer (std::string("ARG"), 3, 3, 3, 3, 3802, 136, 1.97, 0.14, 3.34, 0.24, -62.8, 9.6, -68.8, 12.2, -60.8, 9.5, -83.5, 10.0);
      add_rotamer (std::string("ASN"), 1, 1, 0, 0, 1119, 15, 0.19, 0.04, 1.34, 0.28, 50.3, 14.4, -115.0, 20.4, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 1, 2, 0, 0, 1119, 210, 2.60, 0.14, 18.77, 0.95, 64.5, 13.3, -53.9, 15.2, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 1, 3, 0, 0, 1119, 570, 7.05, 0.23, 50.94, 1.22, 64.6, 7.7, 1.5, 16.3, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 1, 4, 0, 0, 1119, 290, 3.59, 0.17, 25.92, 1.07, 60.0, 8.9, 57.0, 16.6, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 1, 5, 0, 0, 1119, 30, 0.37, 0.06, 2.68, 0.39, 68.9, 13.0, 101.9, 12.0, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 1, 6, 0, 0, 1119, 4, 0.05, 0.02, 0.36, 0.15, 69.3, 5.0, 175.1, 16.5, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 2, 1, 0, 0, 2449, 250, 3.09, 0.16, 10.21, 0.50, -176.0, 14.2, -114.6, 19.9, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 2, 2, 0, 0, 2449, 349, 4.32, 0.18, 14.25, 0.58, -173.5, 11.6, -66.3, 13.6, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 2, 3, 0, 0, 2449, 577, 7.14, 0.23, 23.56, 0.70, -170.8, 10.4, -20.2, 12.7, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 2, 4, 0, 0, 2449, 795, 9.84, 0.27, 32.46, 0.77, -169.3, 11.6, 24.3, 12.3, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 2, 5, 0, 0, 2449, 444, 5.49, 0.21, 18.13, 0.64, -171.9, 11.8, 60.6, 10.8, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 2, 6, 0, 0, 2449, 34, 0.42, 0.06, 1.39, 0.19, -160.3, 15.0, 121.5, 28.1, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 3, 1, 0, 0, 4513, 49, 0.61, 0.07, 1.09, 0.13, -77.3, 12.3, -137.6, 24.1, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 3, 2, 0, 0, 4513, 1503, 18.60, 0.35, 33.30, 0.57, -65.7, 11.1, -63.9, 13.8, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 3, 3, 0, 0, 4513, 2279, 28.20, 0.41, 50.50, 0.61, -70.4, 8.7, -23.2, 13.7, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 3, 4, 0, 0, 4513, 100, 1.24, 0.10, 2.22, 0.18, -79.5, 14.5, 34.3, 13.9, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 3, 5, 0, 0, 4513, 336, 4.16, 0.18, 7.45, 0.32, -65.2, 13.9, 96.5, 17.4, 0, -1, 0, -1);
      add_rotamer (std::string("ASN"), 3, 6, 0, 0, 4513, 246, 3.04, 0.16, 5.45, 0.28, -64.7, 9.5, 139.8, 15.9, 0, -1, 0, -1);
      add_rotamer (std::string("ASP"), 1, 1, 0, 0, 1734, 218, 2.08, 0.11, 12.57, 0.65, 57.1, 11.5, 54.3, 18.3, 0, -1, 0, -1);
      add_rotamer (std::string("ASP"), 1, 2, 0, 0, 1734, 1152, 10.97, 0.25, 66.44, 0.93, 62.5, 7.6, 1.3, 14.7, 0, -1, 0, -1);
      add_rotamer (std::string("ASP"), 1, 3, 0, 0, 1734, 364, 3.47, 0.15, 20.99, 0.80, 62.4, 10.6, -55.8, 16.0, 0, -1, 0, -1);
      add_rotamer (std::string("ASP"), 2, 1, 0, 0, 3284, 916, 8.72, 0.22, 27.89, 0.64, -173.6, 12.3, 58.5, 16.3, 0, -1, 0, -1);
      add_rotamer (std::string("ASP"), 2, 2, 0, 0, 3284, 1850, 17.61, 0.30, 56.33, 0.71, -172.3, 11.0, -0.8, 16.1, 0, -1, 0, -1);
      add_rotamer (std::string("ASP"), 2, 3, 0, 0, 3284, 518, 4.93, 0.17, 15.77, 0.52, -167.9, 12.8, -55.7, 18.3, 0, -1, 0, -1);
      add_rotamer (std::string("ASP"), 3, 1, 0, 0, 5485, 200, 1.90, 0.11, 3.65, 0.21, -69.1, 19.5, 65.0, 17.4, 0, -1, 0, -1);
      add_rotamer (std::string("ASP"), 3, 2, 0, 0, 5485, 3242, 30.87, 0.37, 59.11, 0.54, -72.1, 8.2, -12.7, 11.2, 0, -1, 0, -1);
      add_rotamer (std::string("ASP"), 3, 3, 0, 0, 5485, 2043, 19.45, 0.32, 37.25, 0.53, -65.4, 10.1, -49.8, 14.6, 0, -1, 0, -1);
      add_rotamer (std::string("CYS"), 1, 0, 0, 0, 415, 415, 15.94, 0.59, 100.00, 0.00, 63.7, 11.5, 0, -1, 0, -1, 0, -1);
      add_rotamer (std::string("CYS"), 2, 0, 0, 0, 714, 714, 27.42, 0.71, 100.00, 0.00, -177.3, 11.5, 0, -1, 0, -1, 0, -1);
      add_rotamer (std::string("CYS"), 3, 0, 0, 0, 1475, 1475, 56.64, 0.79, 100.00, 0.00, -64.3, 10.6, 0, -1, 0, -1, 0, -1);
      add_rotamer (std::string("GLN"), 1, 1, 1, 0, 498, 0, 0.02, 0.01, 0.24, 0.18, 64.1, 13.0, 74.9, 16.9, -124.0, 19.6, 0, -1);
      add_rotamer (std::string("GLN"), 1, 1, 2, 0, 498, 5, 0.08, 0.03, 1.03, 0.37, 64.9, 13.6, 86.9, 14.9, -33.0, 25.6, 0, -1);
      add_rotamer (std::string("GLN"), 1, 1, 3, 0, 498, 26, 0.41, 0.07, 5.05, 0.80, 62.5, 11.4, 84.6, 8.0, 38.5, 20.0, 0, -1);
      add_rotamer (std::string("GLN"), 1, 1, 4, 0, 498, 2, 0.03, 0.02, 0.32, 0.21, 67.7, 14.6, 84.8, 16.8, 117.2, 26.4, 0, -1);
      add_rotamer (std::string("GLN"), 1, 2, 1, 0, 498, 21, 0.33, 0.06, 4.07, 0.72, 61.5, 13.9, -174.9, 17.4, -179.8, 26.7, 0, -1);
      add_rotamer (std::string("GLN"), 1, 2, 2, 0, 498, 87, 1.39, 0.12, 17.24, 1.38, 64.0, 9.8, -177.6, 12.1, -79.1, 23.4, 0, -1);
      add_rotamer (std::string("GLN"), 1, 2, 3, 0, 498, 143, 2.51, 0.16, 31.01, 1.69, 65.1, 12.2, -177.5, 14.4, -4.1, 27.0, 0, -1);
      add_rotamer (std::string("GLN"), 1, 2, 4, 0, 498, 110, 1.63, 0.13, 20.16, 1.47, 65.4, 10.8, -177.1, 13.2, 79.5, 22.4, 0, -1);
      add_rotamer (std::string("GLN"), 1, 3, 1, 0, 498, 0, 0.01, 0.01, 0.11, 0.12, 64.1, 13.3, -82.4, 14.6, -111.9, 29.4, 0, -1);
      add_rotamer (std::string("GLN"), 1, 3, 2, 0, 498, 30, 0.73, 0.09, 8.99, 1.05, 66.3, 13.5, -76.0, 12.9, -34.4, 21.6, 0, -1);
      add_rotamer (std::string("GLN"), 1, 3, 3, 0, 498, 63, 0.76, 0.09, 9.45, 1.07, 64.8, 9.5, -89.6, 5.9, 38.2, 17.2, 0, -1);
      add_rotamer (std::string("GLN"), 1, 3, 4, 0, 498, 11, 0.19, 0.05, 2.33, 0.55, 57.6, 19.5, -79.7, 16.2, 123.9, 19.5, 0, -1);
      add_rotamer (std::string("GLN"), 2, 1, 1, 0, 1905, 77, 1.21, 0.11, 3.92, 0.36, -174.0, 11.3, 60.6, 10.5, -124.1, 20.4, 0, -1);
      add_rotamer (std::string("GLN"), 2, 1, 2, 0, 1905, 75, 1.38, 0.12, 4.46, 0.39, -175.4, 15.2, 74.1, 12.7, -37.5, 28.2, 0, -1);
      add_rotamer (std::string("GLN"), 2, 1, 3, 0, 1905, 487, 7.76, 0.28, 25.11, 0.81, -176.1, 10.7, 65.7, 9.7, 44.6, 19.5, 0, -1);
      add_rotamer (std::string("GLN"), 2, 1, 4, 0, 1905, 12, 0.21, 0.05, 0.68, 0.15, -178.1, 13.6, 70.4, 12.0, 109.0, 21.7, 0, -1);
      add_rotamer (std::string("GLN"), 2, 2, 1, 0, 1905, 47, 0.83, 0.09, 2.70, 0.30, -175.5, 10.3, 178.6, 13.1, -179.1, 23.0, 0, -1);
      add_rotamer (std::string("GLN"), 2, 2, 2, 0, 1905, 230, 3.93, 0.20, 12.73, 0.62, -178.0, 10.8, 176.1, 12.9, -77.6, 25.4, 0, -1);
      add_rotamer (std::string("GLN"), 2, 2, 3, 0, 1905, 594, 9.49, 0.30, 30.72, 0.86, -177.0, 9.6, 177.3, 12.2, 1.0, 25.4, 0, -1);
      add_rotamer (std::string("GLN"), 2, 2, 4, 0, 1905, 284, 4.48, 0.22, 14.49, 0.66, -176.6, 9.8, -179.4, 15.0, 74.8, 23.1, 0, -1);
      add_rotamer (std::string("GLN"), 2, 3, 1, 0, 1905, 3, 0.04, 0.02, 0.13, 0.07, -165.2, 15.1, -77.7, 19.8, -112.0, 27.8, 0, -1);
      add_rotamer (std::string("GLN"), 2, 3, 2, 0, 1905, 75, 1.19, 0.11, 3.86, 0.36, -169.4, 14.9, -81.4, 11.1, -34.9, 17.3, 0, -1);
      add_rotamer (std::string("GLN"), 2, 3, 3, 0, 1905, 8, 0.16, 0.04, 0.53, 0.14, -165.7, 14.5, -83.7, 19.7, 46.1, 24.3, 0, -1);
      add_rotamer (std::string("GLN"), 2, 3, 4, 0, 1905, 13, 0.21, 0.05, 0.67, 0.15, -170.6, 16.7, -75.8, 9.9, 125.3, 17.6, 0, -1);
      add_rotamer (std::string("GLN"), 3, 1, 1, 0, 3762, 20, 0.34, 0.06, 0.56, 0.10, -70.8, 11.8, 73.4, 15.6, -123.8, 16.4, 0, -1);
      add_rotamer (std::string("GLN"), 3, 1, 2, 0, 3762, 66, 0.91, 0.10, 1.49, 0.16, -64.6, 11.7, 86.7, 19.0, -35.4, 22.0, 0, -1);
      add_rotamer (std::string("GLN"), 3, 1, 3, 0, 3762, 128, 2.23, 0.15, 3.66, 0.25, -68.4, 12.1, 74.8, 12.2, 37.4, 18.5, 0, -1);
      add_rotamer (std::string("GLN"), 3, 1, 4, 0, 3762, 7, 0.10, 0.03, 0.17, 0.05, -72.0, 17.6, 83.7, 17.3, 110.1, 18.7, 0, -1);
      add_rotamer (std::string("GLN"), 3, 2, 1, 0, 3762, 132, 2.08, 0.15, 3.41, 0.24, -66.9, 9.8, 179.0, 12.7, -177.9, 26.3, 0, -1);
      add_rotamer (std::string("GLN"), 3, 2, 2, 0, 3762, 570, 9.06, 0.30, 14.85, 0.47, -66.8, 10.5, -179.7, 13.8, -76.8, 24.3, 0, -1);
      add_rotamer (std::string("GLN"), 3, 2, 3, 0, 3762, 1145, 18.53, 0.40, 30.37, 0.61, -67.5, 9.6, 177.6, 12.7, -1.1, 25.8, 0, -1);
      add_rotamer (std::string("GLN"), 3, 2, 4, 0, 3762, 468, 7.88, 0.28, 12.91, 0.45, -65.8, 9.2, -178.9, 14.0, 75.3, 22.6, 0, -1);
      add_rotamer (std::string("GLN"), 3, 3, 1, 0, 3762, 19, 0.31, 0.06, 0.50, 0.09, -66.1, 15.0, -82.1, 10.6, -111.8, 29.1, 0, -1);
      add_rotamer (std::string("GLN"), 3, 3, 2, 0, 3762, 917, 14.66, 0.37, 24.02, 0.57, -63.4, 9.4, -63.2, 10.6, -46.3, 19.1, 0, -1);
      add_rotamer (std::string("GLN"), 3, 3, 3, 0, 3762, 137, 2.45, 0.16, 4.01, 0.26, -67.0, 13.4, -76.5, 13.1, 44.4, 26.9, 0, -1);
      add_rotamer (std::string("GLN"), 3, 3, 4, 0, 3762, 153, 2.48, 0.16, 4.06, 0.26, -68.5, 12.8, -61.2, 15.2, 119.9, 17.7, 0, -1);
      add_rotamer (std::string("GLU"), 1, 1, 1, 0, 810, 13, 0.13, 0.03, 1.60, 0.36, 54.3, 17.7, 83.1, 11.1, 49.0, 15.9, 0, -1);
      add_rotamer (std::string("GLU"), 1, 1, 2, 0, 810, 21, 0.21, 0.04, 2.57, 0.45, 54.5, 20.3, 88.3, 11.9, 6.4, 14.6, 0, -1);
      add_rotamer (std::string("GLU"), 1, 1, 3, 0, 810, 3, 0.03, 0.01, 0.39, 0.18, 50.8, 21.1, 78.6, 18.2, -61.4, 18.2, 0, -1);
      add_rotamer (std::string("GLU"), 1, 2, 1, 0, 810, 158, 1.50, 0.10, 18.26, 1.11, 64.2, 13.0, -178.4, 16.9, 58.7, 16.6, 0, -1);
      add_rotamer (std::string("GLU"), 1, 2, 2, 0, 810, 235, 2.56, 0.13, 31.03, 1.33, 64.6, 13.5, -177.4, 12.4, 1.7, 15.4, 0, -1);
      add_rotamer (std::string("GLU"), 1, 2, 3, 0, 810, 157, 1.53, 0.10, 18.61, 1.12, 65.3, 13.4, -176.6, 14.6, -58.5, 17.2, 0, -1);
      add_rotamer (std::string("GLU"), 1, 3, 1, 0, 810, 58, 0.47, 0.06, 5.67, 0.66, 58.6, 11.1, -93.4, 8.7, 51.0, 16.7, 0, -1);
      add_rotamer (std::string("GLU"), 1, 3, 2, 0, 810, 145, 1.31, 0.09, 15.90, 1.05, 68.3, 12.8, -81.5, 9.1, 2.6, 16.4, 0, -1);
      add_rotamer (std::string("GLU"), 1, 3, 3, 0, 810, 20, 0.49, 0.06, 5.97, 0.68, 65.1, 19.8, -74.4, 13.7, -51.1, 17.4, 0, -1);
      add_rotamer (std::string("GLU"), 2, 1, 1, 0, 3257, 308, 3.00, 0.14, 9.05, 0.41, -172.8, 14.1, 62.1, 13.8, 52.1, 15.4, 0, -1);
      add_rotamer (std::string("GLU"), 2, 1, 2, 0, 3257, 393, 4.09, 0.16, 12.36, 0.47, -178.4, 10.6, 67.8, 9.7, 9.7, 13.7, 0, -1);
      add_rotamer (std::string("GLU"), 2, 1, 3, 0, 3257, 62, 0.67, 0.07, 2.02, 0.20, -174.2, 17.1, 72.2, 19.5, -65.1, 16.3, 0, -1);
      add_rotamer (std::string("GLU"), 2, 2, 1, 0, 3257, 614, 6.00, 0.20, 18.11, 0.55, -177.6, 12.1, 175.8, 14.3, 57.3, 17.4, 0, -1);
      add_rotamer (std::string("GLU"), 2, 2, 2, 0, 3257, 1167, 12.00, 0.27, 36.21, 0.69, -177.3, 10.6, 177.9, 12.0, -0.2, 15.9, 0, -1);
      add_rotamer (std::string("GLU"), 2, 2, 3, 0, 3257, 551, 5.72, 0.19, 17.28, 0.54, -175.2, 13.4, 179.2, 14.2, -57.4, 17.0, 0, -1);
      add_rotamer (std::string("GLU"), 2, 3, 1, 0, 3257, 11, 0.13, 0.03, 0.39, 0.09, -155.8, 19.5, -76.6, 27.9, 63.4, 18.4, 0, -1);
      add_rotamer (std::string("GLU"), 2, 3, 2, 0, 3257, 65, 0.68, 0.07, 2.05, 0.20, -169.0, 14.3, -86.3, 12.5, -14.5, 13.8, 0, -1);
      add_rotamer (std::string("GLU"), 2, 3, 3, 0, 3257, 86, 0.84, 0.08, 2.54, 0.23, -166.0, 19.3, -80.1, 15.4, -49.5, 14.5, 0, -1);
      add_rotamer (std::string("GLU"), 3, 1, 1, 0, 5765, 193, 2.10, 0.12, 3.58, 0.20, -66.3, 18.6, 71.1, 17.2, 52.3, 15.4, 0, -1);
      add_rotamer (std::string("GLU"), 3, 1, 2, 0, 5765, 395, 3.92, 0.16, 6.69, 0.27, -66.2, 9.8, 82.2, 8.0, 1.9, 15.7, 0, -1);
      add_rotamer (std::string("GLU"), 3, 1, 3, 0, 5765, 76, 0.73, 0.07, 1.25, 0.12, -66.8, 18.3, 91.0, 17.5, -54.1, 17.6, 0, -1);
      add_rotamer (std::string("GLU"), 3, 2, 1, 0, 5765, 703, 7.50, 0.22, 12.79, 0.36, -68.3, 12.6, 179.3, 16.1, 56.0, 16.9, 0, -1);
      add_rotamer (std::string("GLU"), 3, 2, 2, 0, 5765, 1881, 18.84, 0.32, 32.13, 0.50, -67.7, 9.1, 177.8, 12.0, -2.2, 15.2, 0, -1);
      add_rotamer (std::string("GLU"), 3, 2, 3, 0, 5765, 890, 9.00, 0.24, 15.34, 0.39, -65.3, 11.5, -178.2, 14.0, -54.7, 16.7, 0, -1);
      add_rotamer (std::string("GLU"), 3, 3, 1, 0, 5765, 127, 1.40, 0.10, 2.39, 0.16, -64.1, 13.7, -79.0, 16.9, 64.0, 18.1, 0, -1);
      add_rotamer (std::string("GLU"), 3, 3, 2, 0, 5765, 659, 6.85, 0.21, 11.68, 0.35, -64.2, 10.9, -71.2, 11.2, -9.8, 14.3, 0, -1);
      add_rotamer (std::string("GLU"), 3, 3, 3, 0, 5765, 841, 8.30, 0.23, 14.15, 0.37, -67.7, 11.1, -60.7, 11.6, -52.4, 13.9, 0, -1);
      add_rotamer (std::string("HIS"), 1, 1, 0, 0, 481, 185, 4.74, 0.28, 38.46, 1.81, 63.0, 10.9, 85.6, 15.5, 0, -1, 0, -1);
      add_rotamer (std::string("HIS"), 1, 2, 0, 0, 481, 21, 0.54, 0.10, 4.37, 0.76, 64.8, 8.7, 166.2, 32.8, 0, -1, 0, -1);
      add_rotamer (std::string("HIS"), 1, 3, 0, 0, 481, 275, 7.05, 0.33, 57.17, 1.84, 65.4, 11.1, -79.5, 15.5, 0, -1, 0, -1);
      add_rotamer (std::string("HIS"), 2, 1, 0, 0, 1277, 598, 15.33, 0.47, 46.83, 1.14, -178.4, 11.3, 71.5, 16.7, 0, -1, 0, -1);
      add_rotamer (std::string("HIS"), 2, 2, 0, 0, 1277, 206, 5.28, 0.29, 16.13, 0.84, -172.8, 11.4, -170.3, 30.6, 0, -1, 0, -1);
      add_rotamer (std::string("HIS"), 2, 3, 0, 0, 1277, 473, 12.13, 0.43, 37.04, 1.10, -172.6, 11.6, -83.8, 19.8, 0, -1, 0, -1);
      add_rotamer (std::string("HIS"), 3, 1, 0, 0, 2142, 566, 14.51, 0.46, 26.42, 0.78, -66.0, 10.9, 85.6, 18.9, 0, -1, 0, -1);
      add_rotamer (std::string("HIS"), 3, 2, 0, 0, 2142, 420, 10.77, 0.41, 19.61, 0.70, -68.1, 8.6, 168.7, 27.7, 0, -1, 0, -1);
      add_rotamer (std::string("HIS"), 3, 3, 0, 0, 2142, 1156, 29.64, 0.60, 53.97, 0.88, -63.7, 10.9, -72.9, 19.4, 0, -1, 0, -1);
      add_rotamer (std::string("ILE"), 1, 1, 0, 0, 1061, 47, 0.56, 0.07, 4.43, 0.52, 60.6, 17.7, 85.4, 16.1, 0, -1, 0, -1);
      add_rotamer (std::string("ILE"), 1, 2, 0, 0, 1061, 1009, 12.02, 0.29, 95.10, 0.54, 61.1, 6.6, 171.0, 8.1, 0, -1, 0, -1);
      add_rotamer (std::string("ILE"), 1, 3, 0, 0, 1061, 5, 0.06, 0.02, 0.47, 0.17, 61.7, 8.8, -80.0, 9.2, 0, -1, 0, -1);
      add_rotamer (std::string("ILE"), 2, 1, 0, 0, 749, 224, 2.67, 0.14, 29.91, 1.37, -167.9, 11.5, 66.8, 12.1, 0, -1, 0, -1);
      add_rotamer (std::string("ILE"), 2, 2, 0, 0, 749, 516, 6.15, 0.21, 68.89, 1.38, -171.4, 9.7, 167.4, 7.8, 0, -1, 0, -1);
      add_rotamer (std::string("ILE"), 2, 3, 0, 0, 749, 9, 0.11, 0.03, 1.20, 0.32, -165.5, 25.8, -78.0, 16.1, 0, -1, 0, -1);
      add_rotamer (std::string("ILE"), 3, 1, 0, 0, 6582, 107, 1.28, 0.10, 1.63, 0.13, -67.1, 15.1, 83.0, 19.5, 0, -1, 0, -1);
      add_rotamer (std::string("ILE"), 3, 2, 0, 0, 6582, 5168, 61.58, 0.43, 78.52, 0.41, -63.8, 6.6, 170.1, 8.4, 0, -1, 0, -1);
      add_rotamer (std::string("ILE"), 3, 3, 0, 0, 6582, 1307, 15.57, 0.32, 19.86, 0.40, -59.2, 7.5, -61.0, 9.2, 0, -1, 0, -1);
      add_rotamer (std::string("LEU"), 1, 1, 0, 0, 148, 97, 0.73, 0.06, 65.54, 3.18, 58.7, 14.5, 80.7, 17.6, 0, -1, 0, -1);
      add_rotamer (std::string("LEU"), 1, 2, 0, 0, 148, 48, 0.36, 0.04, 32.43, 3.13, 71.8, 13.9, 164.6, 14.8, 0, -1, 0, -1);
      add_rotamer (std::string("LEU"), 1, 3, 0, 0, 148, 3, 0.02, 0.01, 2.03, 0.94, 58.2, 13.7, -73.6, 12.4, 0, -1, 0, -1);
      add_rotamer (std::string("LEU"), 2, 1, 0, 0, 4222, 3830, 28.91, 0.32, 90.72, 0.36, -179.2, 9.9, 63.0, 8.1, 0, -1, 0, -1);
      add_rotamer (std::string("LEU"), 2, 2, 0, 0, 4222, 339, 2.56, 0.11, 8.03, 0.34, -164.9, 17.4, 170.7, 27.0, 0, -1, 0, -1);
      add_rotamer (std::string("LEU"), 2, 3, 0, 0, 4222, 53, 0.40, 0.04, 1.26, 0.14, -169.8, 14.2, -73.1, 18.1, 0, -1, 0, -1);
      add_rotamer (std::string("LEU"), 3, 1, 0, 0, 8877, 483, 3.65, 0.13, 5.44, 0.20, -86.1, 14.9, 54.6, 24.5, 0, -1, 0, -1);
      add_rotamer (std::string("LEU"), 3, 2, 0, 0, 8877, 8282, 62.52, 0.34, 93.30, 0.22, -64.7, 9.1, 174.5, 8.6, 0, -1, 0, -1);
      add_rotamer (std::string("LEU"), 3, 3, 0, 0, 8877, 112, 0.85, 0.06, 1.26, 0.10, -81.5, 12.8, -55.0, 19.6, 0, -1, 0, -1);
      add_rotamer (std::string("LYS"), 1, 1, 1, 1, 599, 0, 0.00, 0.00, 0.03, 0.06, 66.8, 27.0, 76.3, 19.5, 66.4, 13.3, 71.1, 19.1);
      add_rotamer (std::string("LYS"), 1, 1, 1, 2, 599, 3, 0.03, 0.01, 0.41, 0.21, 69.9, 26.0, 76.7, 19.3, 66.8, 19.9, 175.9, 16.7);
      add_rotamer (std::string("LYS"), 1, 1, 1, 3, 599, 2, 0.02, 0.01, 0.23, 0.16, 57.5, 32.2, 74.0, 18.9, 85.8, 21.5, -83.1, 19.7);
      add_rotamer (std::string("LYS"), 1, 1, 2, 1, 599, 3, 0.03, 0.02, 0.46, 0.22, 65.7, 24.6, 78.2, 16.6, 174.6, 18.0, 62.6, 17.7);
      add_rotamer (std::string("LYS"), 1, 1, 2, 2, 599, 2, 0.05, 0.02, 0.71, 0.28, 68.9, 25.1, 76.7, 16.9, 177.2, 15.8, 175.3, 17.5);
      add_rotamer (std::string("LYS"), 1, 1, 2, 3, 599, 5, 0.05, 0.02, 0.68, 0.27, 68.9, 23.4, 77.8, 16.7, -177.5, 18.4, -68.4, 20.5);
      add_rotamer (std::string("LYS"), 1, 1, 3, 1, 599, 0, 0.00, 0.00, 0.00, 0.02, 66.8, 27.0, 82.3, 21.6, -86.0, 21.8, 74.7, 24.0);
      add_rotamer (std::string("LYS"), 1, 1, 3, 2, 599, 1, 0.01, 0.01, 0.14, 0.12, 69.5, 27.1, 85.2, 22.6, -93.8, 17.1, -177.2, 17.1);
      add_rotamer (std::string("LYS"), 1, 1, 3, 3, 599, 0, 0.00, 0.00, 0.01, 0.03, 66.8, 27.0, 82.3, 21.6, -83.6, 20.3, -67.0, 17.5);
      add_rotamer (std::string("LYS"), 1, 2, 1, 1, 599, 22, 0.23, 0.04, 3.37, 0.60, 65.8, 12.5, 175.6, 11.0, 68.3, 21.8, 68.9, 15.9);
      add_rotamer (std::string("LYS"), 1, 2, 1, 2, 599, 46, 0.53, 0.06, 7.66, 0.89, 64.7, 13.2, 175.2, 12.3, 70.9, 16.9, 174.9, 15.8);
      add_rotamer (std::string("LYS"), 1, 2, 1, 3, 599, 6, 0.07, 0.02, 0.99, 0.33, 68.4, 18.2, -179.3, 13.0, 87.4, 16.5, -84.8, 17.8);
      add_rotamer (std::string("LYS"), 1, 2, 2, 1, 599, 68, 0.80, 0.08, 11.46, 1.06, 65.9, 11.4, -178.1, 14.9, 173.2, 16.2, 66.9, 20.0);
      add_rotamer (std::string("LYS"), 1, 2, 2, 2, 599, 266, 3.14, 0.15, 45.16, 1.66, 66.0, 10.7, -179.4, 11.3, -179.5, 13.4, 179.9, 13.3);
      add_rotamer (std::string("LYS"), 1, 2, 2, 3, 599, 65, 0.78, 0.08, 11.24, 1.05, 65.6, 8.0, -178.1, 13.2, -175.9, 16.9, -68.7, 17.4);
      add_rotamer (std::string("LYS"), 1, 2, 3, 1, 599, 5, 0.06, 0.02, 0.89, 0.31, 67.2, 13.4, -175.2, 16.8, -71.5, 19.7, 74.3, 21.7);
      add_rotamer (std::string("LYS"), 1, 2, 3, 2, 599, 58, 0.64, 0.07, 9.19, 0.96, 64.3, 16.1, -172.4, 17.0, -68.2, 18.2, -176.8, 18.3);
      add_rotamer (std::string("LYS"), 1, 2, 3, 3, 599, 26, 0.27, 0.05, 3.86, 0.64, 67.2, 14.2, -173.7, 14.9, -70.3, 15.1, -68.0, 15.2);
      add_rotamer (std::string("LYS"), 1, 3, 1, 1, 599, 1, 0.01, 0.01, 0.12, 0.12, 67.2, 20.0, -83.2, 22.0, 80.8, 20.9, 69.9, 18.5);
      add_rotamer (std::string("LYS"), 1, 3, 1, 2, 599, 1, 0.01, 0.01, 0.14, 0.12, 64.1, 21.8, -83.7, 22.4, 88.2, 21.4, 177.6, 16.4);
      add_rotamer (std::string("LYS"), 1, 3, 1, 3, 599, 0, 0.00, 0.00, 0.00, 0.02, 66.9, 21.0, -81.3, 22.2, 88.3, 19.8, -80.2, 19.2);
      add_rotamer (std::string("LYS"), 1, 3, 2, 1, 599, 2, 0.03, 0.01, 0.38, 0.21, 71.8, 22.2, -79.7, 20.6, -178.6, 18.0, 65.4, 16.6);
      add_rotamer (std::string("LYS"), 1, 3, 2, 2, 599, 8, 0.11, 0.03, 1.53, 0.41, 69.4, 21.0, -80.1, 22.4, -178.3, 16.7, 177.0, 18.3);
      add_rotamer (std::string("LYS"), 1, 3, 2, 3, 599, 4, 0.04, 0.02, 0.61, 0.26, 64.2, 18.4, -81.9, 20.6, 174.4, 23.5, -65.5, 20.6);
      add_rotamer (std::string("LYS"), 1, 3, 3, 1, 599, 0, 0.00, 0.00, 0.01, 0.04, 66.9, 21.0, -76.7, 22.5, -78.3, 24.7, 74.7, 24.0);
      add_rotamer (std::string("LYS"), 1, 3, 3, 2, 599, 4, 0.04, 0.02, 0.56, 0.25, 63.7, 20.2, -77.8, 23.3, -67.7, 14.3, 179.7, 16.3);
      add_rotamer (std::string("LYS"), 1, 3, 3, 3, 599, 1, 0.01, 0.01, 0.15, 0.13, 67.5, 20.1, -77.5, 21.6, -75.5, 16.9, -67.1, 16.7);
      add_rotamer (std::string("LYS"), 2, 1, 1, 1, 2910, 11, 0.14, 0.03, 0.43, 0.10, -178.7, 20.1, 68.1, 16.9, 65.3, 12.9, 66.2, 18.5);
      add_rotamer (std::string("LYS"), 2, 1, 1, 2, 2910, 39, 0.46, 0.06, 1.37, 0.18, -172.9, 16.8, 65.9, 16.8, 71.0, 16.4, 179.7, 17.8);
      add_rotamer (std::string("LYS"), 2, 1, 1, 3, 2910, 7, 0.07, 0.02, 0.22, 0.07, -179.1, 14.5, 68.7, 19.9, 81.0, 23.8, -81.3, 19.5);
      add_rotamer (std::string("LYS"), 2, 1, 2, 1, 2910, 70, 0.79, 0.08, 2.34, 0.23, -178.4, 12.7, 67.8, 14.2, 170.7, 17.5, 67.0, 19.4);
      add_rotamer (std::string("LYS"), 2, 1, 2, 2, 2910, 259, 2.99, 0.15, 8.86, 0.43, -177.7, 12.7, 70.3, 13.8, 175.8, 13.2, 179.3, 15.8);
      add_rotamer (std::string("LYS"), 2, 1, 2, 3, 2910, 63, 0.74, 0.08, 2.20, 0.22, -174.2, 16.5, 66.7, 16.1, -178.3, 19.6, -65.6, 18.6);
      add_rotamer (std::string("LYS"), 2, 1, 3, 1, 2910, 4, 0.04, 0.02, 0.11, 0.05, -170.3, 18.9, 87.2, 18.9, -90.8, 20.6, 76.8, 22.6);
      add_rotamer (std::string("LYS"), 2, 1, 3, 2, 2910, 14, 0.17, 0.04, 0.50, 0.11, -172.6, 13.2, 88.2, 18.9, -91.5, 18.2, -177.5, 24.9);
      add_rotamer (std::string("LYS"), 2, 1, 3, 3, 2910, 4, 0.05, 0.02, 0.15, 0.06, -173.8, 16.1, 86.5, 15.9, -86.4, 18.9, -69.3, 18.5);
      add_rotamer (std::string("LYS"), 2, 2, 1, 1, 2910, 71, 0.82, 0.08, 2.42, 0.23, -174.3, 16.1, 174.4, 17.9, 72.8, 21.4, 70.5, 20.6);
      add_rotamer (std::string("LYS"), 2, 2, 1, 2, 2910, 204, 2.32, 0.13, 6.86, 0.38, -177.5, 12.2, 173.7, 13.6, 71.5, 18.7, 177.8, 17.0);
      add_rotamer (std::string("LYS"), 2, 2, 1, 3, 2910, 29, 0.32, 0.05, 0.94, 0.15, -172.2, 14.5, 168.9, 18.9, 87.1, 21.4, -78.4, 18.3);
      add_rotamer (std::string("LYS"), 2, 2, 2, 1, 2910, 309, 3.53, 0.16, 10.44, 0.46, -176.7, 10.5, 176.0, 14.9, 175.4, 16.2, 65.1, 17.5);
      add_rotamer (std::string("LYS"), 2, 2, 2, 2, 2910, 1153, 13.45, 0.30, 39.82, 0.74, -177.2, 9.6, 177.1, 11.6, 179.5, 13.1, 179.9, 15.7);
      add_rotamer (std::string("LYS"), 2, 2, 2, 3, 2910, 298, 3.47, 0.16, 10.28, 0.46, -177.1, 8.9, 177.0, 13.0, -176.6, 16.0, -67.4, 17.7);
      add_rotamer (std::string("LYS"), 2, 2, 3, 1, 2910, 22, 0.27, 0.05, 0.79, 0.13, 179.6, 14.4, -178.0, 15.8, -75.8, 20.6, 70.6, 21.7);
      add_rotamer (std::string("LYS"), 2, 2, 3, 2, 2910, 204, 2.38, 0.13, 7.03, 0.39, -175.0, 13.3, -177.3, 16.0, -70.2, 17.1, -176.8, 17.9);
      add_rotamer (std::string("LYS"), 2, 2, 3, 3, 2910, 64, 0.78, 0.08, 2.30, 0.23, -175.4, 12.4, -178.7, 18.2, -71.0, 18.9, -65.1, 18.5);
      add_rotamer (std::string("LYS"), 2, 3, 1, 1, 2910, 1, 0.01, 0.01, 0.03, 0.03, -162.4, 20.1, -81.9, 20.4, 82.2, 20.8, 74.2, 20.7);
      add_rotamer (std::string("LYS"), 2, 3, 1, 2, 2910, 4, 0.04, 0.02, 0.11, 0.05, -163.0, 18.1, -83.1, 19.9, 95.7, 19.6, -178.9, 21.0);
      add_rotamer (std::string("LYS"), 2, 3, 1, 3, 2910, 0, 0.00, 0.00, 0.00, 0.01, -164.5, 19.9, -82.8, 21.2, 88.3, 19.8, -80.2, 19.2);
      add_rotamer (std::string("LYS"), 2, 3, 2, 1, 2910, 11, 0.13, 0.03, 0.38, 0.09, -161.2, 17.2, -77.8, 23.7, -177.5, 20.0, 66.4, 14.4);
      add_rotamer (std::string("LYS"), 2, 3, 2, 2, 2910, 40, 0.49, 0.06, 1.45, 0.18, -165.2, 19.3, -87.2, 19.8, -177.2, 19.8, -178.9, 18.5);
      add_rotamer (std::string("LYS"), 2, 3, 2, 3, 2910, 11, 0.13, 0.03, 0.39, 0.09, -166.1, 22.6, -83.0, 20.9, -177.8, 18.1, -67.3, 18.4);
      add_rotamer (std::string("LYS"), 2, 3, 3, 1, 2910, 2, 0.02, 0.01, 0.06, 0.04, -160.1, 20.9, -90.5, 18.7, -80.9, 23.3, 68.3, 26.6);
      add_rotamer (std::string("LYS"), 2, 3, 3, 2, 2910, 10, 0.11, 0.03, 0.32, 0.09, -166.8, 19.3, -96.6, 12.9, -69.4, 15.3, 178.4, 14.6);
      add_rotamer (std::string("LYS"), 2, 3, 3, 3, 2910, 6, 0.06, 0.02, 0.17, 0.06, -168.0, 17.8, -93.8, 14.0, -76.0, 17.4, -65.7, 16.6);
      add_rotamer (std::string("LYS"), 3, 1, 1, 1, 5105, 5, 0.06, 0.02, 0.10, 0.04, -88.0, 19.5, 81.2, 19.8, 68.0, 13.0, 69.3, 17.1);
      add_rotamer (std::string("LYS"), 3, 1, 1, 2, 5105, 14, 0.16, 0.04, 0.27, 0.06, -80.9, 21.8, 81.3, 21.0, 66.9, 19.5, -179.6, 24.1);
      add_rotamer (std::string("LYS"), 3, 1, 1, 3, 5105, 3, 0.03, 0.02, 0.05, 0.03, -86.8, 20.3, 86.0, 19.6, 84.3, 20.7, -83.2, 18.3);
      add_rotamer (std::string("LYS"), 3, 1, 2, 1, 5105, 33, 0.33, 0.05, 0.56, 0.09, -80.7, 23.8, 75.7, 23.4, 176.2, 22.0, 62.3, 19.4);
      add_rotamer (std::string("LYS"), 3, 1, 2, 2, 5105, 56, 0.74, 0.08, 1.26, 0.13, -81.0, 23.1, 74.0, 21.2, -178.3, 18.4, 177.9, 18.5);
      add_rotamer (std::string("LYS"), 3, 1, 2, 3, 5105, 29, 0.30, 0.05, 0.51, 0.08, -87.6, 17.8, 74.5, 25.3, 178.0, 24.9, -61.8, 21.2);
      add_rotamer (std::string("LYS"), 3, 1, 3, 1, 5105, 2, 0.02, 0.01, 0.03, 0.02, -86.6, 21.7, 83.2, 24.1, -85.6, 20.2, 68.2, 26.5);
      add_rotamer (std::string("LYS"), 3, 1, 3, 2, 5105, 5, 0.06, 0.02, 0.10, 0.04, -82.6, 18.5, 71.2, 28.5, -96.3, 16.5, -172.0, 20.3);
      add_rotamer (std::string("LYS"), 3, 1, 3, 3, 5105, 1, 0.01, 0.01, 0.02, 0.02, -85.8, 22.3, 78.0, 23.9, -86.1, 21.0, -66.3, 16.9);
      add_rotamer (std::string("LYS"), 3, 2, 1, 1, 5105, 113, 1.31, 0.10, 2.21, 0.17, -70.1, 12.8, 178.9, 16.4, 73.0, 18.8, 72.3, 18.0);
      add_rotamer (std::string("LYS"), 3, 2, 1, 2, 5105, 294, 3.48, 0.16, 5.87, 0.27, -68.5, 11.2, 176.2, 15.7, 69.4, 16.1, 177.3, 15.9);
      add_rotamer (std::string("LYS"), 3, 2, 1, 3, 5105, 30, 0.39, 0.05, 0.65, 0.09, -70.3, 15.4, 174.9, 19.8, 84.2, 17.2, -76.5, 18.0);
      add_rotamer (std::string("LYS"), 3, 2, 2, 1, 5105, 445, 5.29, 0.20, 8.92, 0.33, -67.1, 10.4, -178.4, 14.6, 177.7, 16.7, 66.5, 17.3);
      add_rotamer (std::string("LYS"), 3, 2, 2, 2, 5105, 1994, 22.79, 0.37, 38.46, 0.56, -67.1, 9.0, -179.4, 11.6, -179.4, 13.4, 179.5, 15.0);
      add_rotamer (std::string("LYS"), 3, 2, 2, 3, 5105, 458, 5.44, 0.20, 9.18, 0.33, -66.8, 9.8, -178.0, 12.9, -177.5, 15.1, -65.9, 16.9);
      add_rotamer (std::string("LYS"), 3, 2, 3, 1, 5105, 42, 0.48, 0.06, 0.82, 0.10, -66.8, 13.1, -174.8, 18.2, -76.5, 23.6, 78.2, 24.3);
      add_rotamer (std::string("LYS"), 3, 2, 3, 2, 5105, 328, 3.83, 0.17, 6.47, 0.28, -67.6, 10.3, -175.0, 14.5, -72.6, 15.3, -176.5, 16.1);
      add_rotamer (std::string("LYS"), 3, 2, 3, 3, 5105, 121, 1.39, 0.10, 2.35, 0.17, -65.1, 11.1, -174.8, 14.1, -72.3, 16.3, -65.7, 14.5);
      add_rotamer (std::string("LYS"), 3, 3, 1, 1, 5105, 5, 0.08, 0.02, 0.13, 0.04, -64.8, 10.7, -75.8, 23.0, 85.4, 20.4, 76.5, 20.7);
      add_rotamer (std::string("LYS"), 3, 3, 1, 2, 5105, 28, 0.32, 0.05, 0.54, 0.08, -62.3, 13.4, -76.6, 19.6, 91.0, 18.1, -179.6, 19.6);
      add_rotamer (std::string("LYS"), 3, 3, 1, 3, 5105, 4, 0.04, 0.02, 0.07, 0.03, -62.3, 14.4, -83.2, 20.5, 88.3, 19.6, -84.3, 19.4);
      add_rotamer (std::string("LYS"), 3, 3, 2, 1, 5105, 154, 1.79, 0.12, 3.02, 0.20, -63.5, 13.1, -67.5, 15.3, -177.9, 18.8, 64.3, 19.8);
      add_rotamer (std::string("LYS"), 3, 3, 2, 2, 5105, 592, 6.96, 0.22, 11.75, 0.37, -62.2, 10.8, -66.1, 12.4, -177.3, 12.5, -177.9, 14.8);
      add_rotamer (std::string("LYS"), 3, 3, 2, 3, 5105, 194, 2.12, 0.13, 3.57, 0.21, -60.1, 10.5, -67.0, 13.2, -174.3, 18.3, -69.4, 18.3);
      add_rotamer (std::string("LYS"), 3, 3, 3, 1, 5105, 13, 0.15, 0.03, 0.26, 0.06, -65.2, 13.9, -68.9, 18.8, -76.9, 24.7, 78.3, 21.6);
      add_rotamer (std::string("LYS"), 3, 3, 3, 2, 5105, 107, 1.25, 0.10, 2.12, 0.16, -63.4, 12.1, -66.5, 17.6, -70.5, 14.3, -179.8, 14.1);
      add_rotamer (std::string("LYS"), 3, 3, 3, 3, 5105, 35, 0.42, 0.06, 0.71, 0.10, -60.5, 11.4, -68.5, 19.4, -73.1, 16.7, -72.7, 22.6);
      add_rotamer (std::string("MET"), 1, 1, 1, 0, 221, 11, 0.38, 0.09, 5.26, 1.22, 60.8, 12.7, 78.3, 8.1, 73.3, 14.2, 0, -1);
      add_rotamer (std::string("MET"), 1, 1, 2, 0, 221, 7, 0.19, 0.06, 2.63, 0.88, 57.6, 17.2, 78.1, 12.1, 177.7, 26.3, 0, -1);
      add_rotamer (std::string("MET"), 1, 1, 3, 0, 221, 0, 0.02, 0.02, 0.25, 0.27, 59.4, 15.4, 77.8, 12.6, -97.4, 20.6, 0, -1);
      add_rotamer (std::string("MET"), 1, 2, 1, 0, 221, 75, 2.53, 0.23, 35.00, 2.62, 64.4, 8.4, -178.3, 12.5, 76.1, 17.4, 0, -1);
      add_rotamer (std::string("MET"), 1, 2, 2, 0, 221, 43, 1.44, 0.18, 19.89, 2.19, 64.9, 7.3, -176.0, 7.7, -175.0, 19.5, 0, -1);
      add_rotamer (std::string("MET"), 1, 2, 3, 0, 221, 78, 2.44, 0.23, 33.80, 2.59, 63.4, 9.8, 179.1, 11.4, -71.8, 14.7, 0, -1);
      add_rotamer (std::string("MET"), 1, 3, 1, 0, 221, 0, 0.01, 0.01, 0.12, 0.19, 72.5, 13.4, -70.1, 14.6, 99.6, 10.6, 0, -1);
      add_rotamer (std::string("MET"), 1, 3, 2, 0, 221, 1, 0.03, 0.03, 0.44, 0.36, 72.2, 12.8, -70.4, 14.7, 174.3, 23.8, 0, -1);
      add_rotamer (std::string("MET"), 1, 3, 3, 0, 221, 6, 0.19, 0.06, 2.60, 0.87, 72.6, 13.3, -72.0, 15.5, -71.4, 11.6, 0, -1);
      add_rotamer (std::string("MET"), 2, 1, 1, 0, 904, 212, 6.90, 0.37, 23.35, 1.15, -176.0, 9.6, 64.0, 8.8, 72.5, 14.4, 0, -1);
      add_rotamer (std::string("MET"), 2, 1, 2, 0, 904, 51, 1.72, 0.19, 5.82, 0.64, -174.5, 11.1, 69.3, 10.4, -166.1, 22.4, 0, -1);
      add_rotamer (std::string("MET"), 2, 1, 3, 0, 904, 29, 0.93, 0.14, 3.13, 0.47, -172.4, 12.9, 76.6, 14.3, -96.9, 20.7, 0, -1);
      add_rotamer (std::string("MET"), 2, 2, 1, 0, 904, 207, 7.02, 0.38, 23.75, 1.16, -177.8, 10.7, 179.2, 12.3, 72.1, 14.1, 0, -1);
      add_rotamer (std::string("MET"), 2, 2, 2, 0, 904, 107, 3.73, 0.28, 12.64, 0.90, -177.4, 12.5, 174.6, 12.4, 177.3, 20.8, 0, -1);
      add_rotamer (std::string("MET"), 2, 2, 3, 0, 904, 236, 7.22, 0.38, 24.45, 1.17, -174.6, 12.3, 179.7, 10.3, -71.6, 16.9, 0, -1);
      add_rotamer (std::string("MET"), 2, 3, 1, 0, 904, 0, 0.08, 0.04, 0.27, 0.14, -178.7, 9.5, -73.7, 12.9, 99.6, 10.6, 0, -1);
      add_rotamer (std::string("MET"), 2, 3, 2, 0, 904, 10, 0.31, 0.08, 1.04, 0.28, -178.2, 13.5, -78.4, 12.2, 173.0, 21.9, 0, -1);
      add_rotamer (std::string("MET"), 2, 3, 3, 0, 904, 52, 1.64, 0.19, 5.54, 0.62, -178.8, 7.3, -82.3, 7.2, -73.4, 11.7, 0, -1);
      add_rotamer (std::string("MET"), 3, 1, 1, 0, 1935, 17, 0.57, 0.11, 0.89, 0.17, -78.6, 15.2, 67.3, 16.8, 73.0, 19.8, 0, -1);
      add_rotamer (std::string("MET"), 3, 1, 2, 0, 1935, 6, 0.18, 0.06, 0.29, 0.10, -78.9, 13.8, 69.3, 13.8, -175.6, 23.8, 0, -1);
      add_rotamer (std::string("MET"), 3, 1, 3, 0, 1935, 2, 0.07, 0.04, 0.11, 0.06, -77.7, 13.5, 70.6, 14.5, -98.9, 19.1, 0, -1);
      add_rotamer (std::string("MET"), 3, 2, 1, 0, 1935, 510, 16.34, 0.55, 25.83, 0.81, -67.4, 9.4, 178.0, 11.6, 70.4, 14.2, 0, -1);
      add_rotamer (std::string("MET"), 3, 2, 2, 0, 1935, 293, 9.31, 0.43, 14.72, 0.66, -67.3, 9.1, 179.2, 9.6, -177.6, 19.6, 0, -1);
      add_rotamer (std::string("MET"), 3, 2, 3, 0, 1935, 343, 11.81, 0.48, 18.67, 0.72, -67.7, 9.0, -176.3, 11.9, -73.7, 13.2, 0, -1);
      add_rotamer (std::string("MET"), 3, 3, 1, 0, 1935, 98, 3.11, 0.26, 4.92, 0.40, -65.8, 8.2, -64.9, 11.1, 99.6, 10.5, 0, -1);
      add_rotamer (std::string("MET"), 3, 3, 2, 0, 1935, 101, 3.32, 0.26, 5.25, 0.41, -62.7, 8.2, -64.0, 12.5, 171.9, 24.2, 0, -1);
      add_rotamer (std::string("MET"), 3, 3, 3, 0, 1935, 565, 18.53, 0.57, 29.31, 0.84, -65.8, 10.3, -61.8, 10.0, -69.4, 13.4, 0, -1);
      add_rotamer (std::string("MSE"), 1, 1, 1, 0, 221, 11, 0.38, 0.09, 5.26, 1.22, 60.8, 12.7, 78.3, 8.1, 73.3, 14.2, 0, -1);
      add_rotamer (std::string("PHE"), 1, 1, 0, 0, 749, 743, 11.06, 0.31, 99.20, 0.27, 63.0, 10.0, -89.6, 9.6, 0, -1, 0, -1);
      add_rotamer (std::string("PHE"), 1, 2, 0, 0, 749, 6, 0.09, 0.03, 0.80, 0.27, 62.0, 12.3, -6.5, 29.7, 0, -1, 0, -1);
      add_rotamer (std::string("PHE"), 2, 1, 0, 0, 2257, 2130, 31.71, 0.46, 94.37, 0.40, -178.8, 10.4, 78.1, 13.6, 0, -1, 0, -1);
      add_rotamer (std::string("PHE"), 2, 2, 0, 0, 2257, 127, 1.89, 0.14, 5.63, 0.40, -174.2, 9.5, 21.2, 24.3, 0, -1, 0, -1);
      add_rotamer (std::string("PHE"), 3, 1, 0, 0, 3712, 3163, 47.08, 0.50, 85.21, 0.48, -66.9, 10.6, -82.3, 16.2, 0, -1, 0, -1);
      add_rotamer (std::string("PHE"), 3, 2, 0, 0, 3712, 549, 8.17, 0.27, 14.79, 0.48, -68.2, 10.4, -15.3, 22.0, 0, -1, 0, -1);
      add_rotamer (std::string("PRO"), 1, 1, 0, 0, 2868, 2868, 50.72, 0.54, 100.00, 0.00, 27.0, 8.8, -34.6, 10.9, 0, -1, 0, -1);
      add_rotamer (std::string("PRO"), 2, 1, 0, 0, 2787, 2787, 49.28, 0.54, 100.00, 0.00, -25.1, 8.1, 36.3, 9.5, 0, -1, 0, -1);
      add_rotamer (std::string("SER"), 1, 0, 0, 0, 4931, 4931, 47.07, 0.40, 100.00, 0.00, 65.3, 10.5, 0, -1, 0, -1, 0, -1);
      add_rotamer (std::string("SER"), 2, 0, 0, 0, 2466, 2466, 23.54, 0.34, 100.00, 0.00, 179.0, 11.6, 0, -1, 0, -1, 0, -1);
      add_rotamer (std::string("SER"), 3, 0, 0, 0, 3078, 3078, 29.38, 0.36, 100.00, 0.00, -63.9, 10.5, 0, -1, 0, -1, 0, -1);
      add_rotamer (std::string("THR"), 1, 0, 0, 0, 4907, 4907, 48.86, 0.41, 100.00, 0.00, 61.1, 8.7, 0, -1, 0, -1, 0, -1);
      add_rotamer (std::string("THR"), 2, 0, 0, 0, 754, 754, 7.51, 0.21, 100.00, 0.00, -173.3, 10.6, 0, -1, 0, -1, 0, -1);
      add_rotamer (std::string("THR"), 3, 0, 0, 0, 4383, 4383, 43.64, 0.40, 100.00, 0.00, -60.4, 7.5, 0, -1, 0, -1, 0, -1);
      add_rotamer (std::string("TRP"), 1, 1, 0, 0, 392, 246, 9.92, 0.49, 62.76, 1.99, 61.2, 10.4, -89.9, 9.8, 0, -1, 0, -1);
      add_rotamer (std::string("TRP"), 1, 2, 0, 0, 392, 14, 0.56, 0.12, 3.57, 0.76, 66.0, 8.2, -6.3, 42.3, 0, -1, 0, -1);
      add_rotamer (std::string("TRP"), 1, 3, 0, 0, 392, 132, 5.32, 0.37, 33.67, 1.95, 61.5, 10.7, 89.2, 10.0, 0, -1, 0, -1);
      add_rotamer (std::string("TRP"), 2, 1, 0, 0, 869, 402, 16.21, 0.60, 46.26, 1.38, -177.3, 12.5, -104.9, 14.3, 0, -1, 0, -1);
      add_rotamer (std::string("TRP"), 2, 2, 0, 0, 869, 144, 5.81, 0.38, 16.57, 1.03, -175.1, 12.4, 17.3, 30.8, 0, -1, 0, -1);
      add_rotamer (std::string("TRP"), 2, 3, 0, 0, 869, 323, 13.02, 0.55, 37.17, 1.34, -179.8, 8.8, 84.7, 9.8, 0, -1, 0, -1);
      add_rotamer (std::string("TRP"), 3, 1, 0, 0, 1219, 132, 5.32, 0.37, 10.83, 0.73, -70.1, 13.6, -92.2, 14.1, 0, -1, 0, -1);
      add_rotamer (std::string("TRP"), 3, 2, 0, 0, 1219, 323, 13.02, 0.55, 26.50, 1.03, -68.6, 9.3, -4.2, 26.1, 0, -1, 0, -1);
      add_rotamer (std::string("TRP"), 3, 3, 0, 0, 1219, 764, 30.81, 0.76, 62.67, 1.13, -67.4, 10.9, 100.3, 15.7, 0, -1, 0, -1);
      add_rotamer (std::string("TYR"), 1, 1, 0, 0, 697, 690, 11.59, 0.34, 99.00, 0.31, 63.6, 10.9, -89.8, 11.3, 0, -1, 0, -1);
      add_rotamer (std::string("TYR"), 1, 2, 0, 0, 697, 7, 0.12, 0.04, 1.00, 0.31, 69.7, 8.4, -9.5, 16.5, 0, -1, 0, -1);
      add_rotamer (std::string("TYR"), 2, 1, 0, 0, 2049, 1934, 32.48, 0.50, 94.39, 0.42, -179.6, 10.6, 77.5, 13.7, 0, -1, 0, -1);
      add_rotamer (std::string("TYR"), 2, 2, 0, 0, 2049, 115, 1.93, 0.15, 5.61, 0.42, -174.2, 11.4, 21.0, 24.4, 0, -1, 0, -1);
      add_rotamer (std::string("TYR"), 3, 1, 0, 0, 3208, 2819, 47.35, 0.53, 87.87, 0.47, -65.8, 10.9, -82.2, 16.3, 0, -1, 0, -1);
      add_rotamer (std::string("TYR"), 3, 2, 0, 0, 3208, 389, 6.53, 0.26, 12.13, 0.47, -67.2, 10.4, -16.7, 22.8, 0, -1, 0, -1);
      add_rotamer (std::string("VAL"), 1, 0, 0, 0, 860, 860, 7.40, 0.20, 100.00, 0.00, 65.5, 11.1, 0, -1, 0, -1, 0, -1);
      add_rotamer (std::string("VAL"), 2, 0, 0, 0, 8585, 8585, 73.90, 0.33, 100.00, 0.00, 175.9, 6.9, 0, -1, 0, -1, 0, -1);
      add_rotamer (std::string("VAL"), 3, 0, 0, 0, 2172, 2172, 18.70, 0.30, 100.00, 0.00, -61.7, 8.4, 0, -1, 0, -1, 0, -1);
 
} 
