/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.ServerAddress;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterType;
import com.mongodb.event.ClusterListener;
import com.mongodb.selector.ServerSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Immutable
public final class ClusterSettings {
    private final List<ServerAddress> hosts;
    private final ClusterConnectionMode mode;
    private final ClusterType requiredClusterType;
    private final String requiredReplicaSetName;
    private final ServerSelector serverSelector;
    private final String description;
    private final long serverSelectionTimeoutMS;
    private final int maxWaitQueueSize;
    private final List<ClusterListener> clusterListeners;

    public static Builder builder() {
        return new Builder();
    }

    public String getDescription() {
        return this.description;
    }

    public List<ServerAddress> getHosts() {
        return this.hosts;
    }

    public ClusterConnectionMode getMode() {
        return this.mode;
    }

    public ClusterType getRequiredClusterType() {
        return this.requiredClusterType;
    }

    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    public ServerSelector getServerSelector() {
        return this.serverSelector;
    }

    public long getServerSelectionTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.serverSelectionTimeoutMS, TimeUnit.MILLISECONDS);
    }

    public int getMaxWaitQueueSize() {
        return this.maxWaitQueueSize;
    }

    public List<ClusterListener> getClusterListeners() {
        return Collections.unmodifiableList(this.clusterListeners);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterSettings that = (ClusterSettings)o;
        if (this.maxWaitQueueSize != that.maxWaitQueueSize) {
            return false;
        }
        if (this.serverSelectionTimeoutMS != that.serverSelectionTimeoutMS) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.hosts.equals(that.hosts)) {
            return false;
        }
        if (this.mode != that.mode) {
            return false;
        }
        if (this.requiredClusterType != that.requiredClusterType) {
            return false;
        }
        if (this.requiredReplicaSetName != null ? !this.requiredReplicaSetName.equals(that.requiredReplicaSetName) : that.requiredReplicaSetName != null) {
            return false;
        }
        if (this.serverSelector != null ? !this.serverSelector.equals(that.serverSelector) : that.serverSelector != null) {
            return false;
        }
        return this.clusterListeners.equals(that.clusterListeners);
    }

    public int hashCode() {
        int result = this.hosts.hashCode();
        result = 31 * result + this.mode.hashCode();
        result = 31 * result + this.requiredClusterType.hashCode();
        result = 31 * result + (this.requiredReplicaSetName != null ? this.requiredReplicaSetName.hashCode() : 0);
        result = 31 * result + (this.serverSelector != null ? this.serverSelector.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (int)(this.serverSelectionTimeoutMS ^ this.serverSelectionTimeoutMS >>> 32);
        result = 31 * result + this.maxWaitQueueSize;
        result = 31 * result + this.clusterListeners.hashCode();
        return result;
    }

    public String toString() {
        return "{hosts=" + this.hosts + ", mode=" + (Object)((Object)this.mode) + ", requiredClusterType=" + (Object)((Object)this.requiredClusterType) + ", requiredReplicaSetName='" + this.requiredReplicaSetName + '\'' + ", serverSelector='" + this.serverSelector + '\'' + ", clusterListeners='" + this.clusterListeners + '\'' + ", serverSelectionTimeout='" + this.serverSelectionTimeoutMS + " ms" + '\'' + ", maxWaitQueueSize=" + this.maxWaitQueueSize + ", description='" + this.description + '\'' + '}';
    }

    public String getShortDescription() {
        return "{hosts=" + this.hosts + ", mode=" + (Object)((Object)this.mode) + ", requiredClusterType=" + (Object)((Object)this.requiredClusterType) + ", serverSelectionTimeout='" + this.serverSelectionTimeoutMS + " ms" + '\'' + ", maxWaitQueueSize=" + this.maxWaitQueueSize + (this.requiredReplicaSetName == null ? "" : ", requiredReplicaSetName='" + this.requiredReplicaSetName + '\'') + (this.description == null ? "" : ", description='" + this.description + '\'') + '}';
    }

    private ClusterSettings(Builder builder) {
        Assertions.notNull("hosts", builder.hosts);
        Assertions.isTrueArgument("hosts size > 0", builder.hosts.size() > 0);
        if (builder.hosts.size() > 1 && builder.requiredClusterType == ClusterType.STANDALONE) {
            throw new IllegalArgumentException("Multiple hosts cannot be specified when using ClusterType.STANDALONE.");
        }
        if (builder.mode == ClusterConnectionMode.SINGLE && builder.hosts.size() > 1) {
            throw new IllegalArgumentException("Can not directly connect to more than one server");
        }
        if (builder.requiredReplicaSetName != null) {
            if (builder.requiredClusterType == ClusterType.UNKNOWN) {
                builder.requiredClusterType = ClusterType.REPLICA_SET;
            } else if (builder.requiredClusterType != ClusterType.REPLICA_SET) {
                throw new IllegalArgumentException("When specifying a replica set name, only ClusterType.UNKNOWN and ClusterType.REPLICA_SET are valid.");
            }
        }
        this.description = builder.description;
        this.hosts = builder.hosts;
        this.mode = builder.mode;
        this.requiredReplicaSetName = builder.requiredReplicaSetName;
        this.requiredClusterType = builder.requiredClusterType;
        this.serverSelector = builder.serverSelector;
        this.serverSelectionTimeoutMS = builder.serverSelectionTimeoutMS;
        this.maxWaitQueueSize = builder.maxWaitQueueSize;
        this.clusterListeners = builder.clusterListeners;
    }

    @NotThreadSafe
    public static final class Builder {
        private List<ServerAddress> hosts;
        private ClusterConnectionMode mode = ClusterConnectionMode.MULTIPLE;
        private ClusterType requiredClusterType = ClusterType.UNKNOWN;
        private String requiredReplicaSetName;
        private ServerSelector serverSelector;
        private String description;
        private long serverSelectionTimeoutMS = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
        private int maxWaitQueueSize = 500;
        private final List<ClusterListener> clusterListeners = new ArrayList<ClusterListener>();

        private Builder() {
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder hosts(List<ServerAddress> hosts) {
            Assertions.notNull("hosts", hosts);
            if (hosts.isEmpty()) {
                throw new IllegalArgumentException("hosts list may not be empty");
            }
            LinkedHashSet<ServerAddress> hostsSet = new LinkedHashSet<ServerAddress>(hosts.size());
            for (ServerAddress host : hosts) {
                Assertions.notNull("host", host);
                hostsSet.add(new ServerAddress(host.getHost(), host.getPort()));
            }
            this.hosts = Collections.unmodifiableList(new ArrayList(hostsSet));
            return this;
        }

        public Builder mode(ClusterConnectionMode mode) {
            this.mode = Assertions.notNull("mode", mode);
            return this;
        }

        public Builder requiredReplicaSetName(String requiredReplicaSetName) {
            this.requiredReplicaSetName = requiredReplicaSetName;
            return this;
        }

        public Builder requiredClusterType(ClusterType requiredClusterType) {
            this.requiredClusterType = Assertions.notNull("requiredClusterType", requiredClusterType);
            return this;
        }

        public Builder serverSelector(ServerSelector serverSelector) {
            this.serverSelector = serverSelector;
            return this;
        }

        public Builder serverSelectionTimeout(long serverSelectionTimeout, TimeUnit timeUnit) {
            this.serverSelectionTimeoutMS = TimeUnit.MILLISECONDS.convert(serverSelectionTimeout, timeUnit);
            return this;
        }

        public Builder maxWaitQueueSize(int maxWaitQueueSize) {
            this.maxWaitQueueSize = maxWaitQueueSize;
            return this;
        }

        public Builder addClusterListener(ClusterListener clusterListener) {
            Assertions.notNull("clusterListener", clusterListener);
            this.clusterListeners.add(clusterListener);
            return this;
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            if (connectionString.getHosts().size() == 1 && connectionString.getRequiredReplicaSetName() == null) {
                this.mode(ClusterConnectionMode.SINGLE).hosts(Collections.singletonList(new ServerAddress(connectionString.getHosts().get(0))));
            } else {
                ArrayList<ServerAddress> seedList = new ArrayList<ServerAddress>();
                for (String cur : connectionString.getHosts()) {
                    seedList.add(new ServerAddress(cur));
                }
                this.mode(ClusterConnectionMode.MULTIPLE).hosts(seedList);
            }
            this.requiredReplicaSetName(connectionString.getRequiredReplicaSetName());
            int maxSize = connectionString.getMaxConnectionPoolSize() != null ? connectionString.getMaxConnectionPoolSize() : 100;
            int waitQueueMultiple = connectionString.getThreadsAllowedToBlockForConnectionMultiplier() != null ? connectionString.getThreadsAllowedToBlockForConnectionMultiplier() : 5;
            this.maxWaitQueueSize(waitQueueMultiple * maxSize);
            if (connectionString.getServerSelectionTimeout() != null) {
                this.serverSelectionTimeout(connectionString.getServerSelectionTimeout().intValue(), TimeUnit.MILLISECONDS);
            }
            return this;
        }

        public ClusterSettings build() {
            return new ClusterSettings(this);
        }
    }
}

