#!/usr/bin/env python3

import importlib.util
import os

from fenrirscreenreader.core.i18n import _

# Load base configuration class
_base_path = os.path.join(os.path.dirname(__file__), "..", "config_base.py")
_spec = importlib.util.spec_from_file_location("config_base", _base_path)
_module = importlib.util.module_from_spec(_spec)
_spec.loader.exec_module(_module)
config_command = _module.config_command


class command(config_command):
    def __init__(self):
        super().__init__()

    def get_description(self):
        return "Select sound driver (genericDriver or gstreamerDriver)"

    def run(self):
        current_driver = self.get_setting("sound", "driver", "genericDriver")

        # Present current driver
        self.present_text(f"Current sound driver: {current_driver}")

        # Toggle between the two available drivers
        if current_driver == "genericDriver":
            new_driver = "gstreamerDriver"
            driver_description = (
                "GStreamer Driver - advanced multimedia framework"
            )
        else:
            new_driver = "genericDriver"
            driver_description = "Generic Driver - uses SOX for audio playback"

        success = self.set_setting("sound", "driver", new_driver)

        if success:
            self.present_text(
                f"Sound driver changed to {new_driver}. {driver_description}"
            )
            self.present_text(
                "Please restart Fenrir for this change to take effect."
            )
            self.play_sound("Accept")
        else:
            self.present_text("Failed to change sound driver")
            self.play_sound("Error")
