/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.Site;
import org.chefproject.core.User;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.service.PortalService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.UserDirectoryService;

public class ContactSupportAction
extends VelocityPortletPaneledAction {
    private static final String STATE_FORM = "form";
    private static final String STATE_CONFIRM = "confirm";
    private static final String STATE_EXCEPTION = "exception";
    private static final String STATE_DOC = "doc";

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        String mode = (String)state.getAttribute("mode");
        if (mode == null || STATE_DOC.equals(mode)) {
            return this.buildDocModeContext(portlet, context, rundata, state);
        }
        if (STATE_FORM.equals(mode)) {
            return this.buildFormModeContext(portlet, context, rundata, state);
        }
        if (STATE_CONFIRM.equals(mode)) {
            return this.buildConfirmModeContext(portlet, context, rundata, state);
        }
        if (STATE_EXCEPTION.equals(mode)) {
            return this.buildExceptionModeContext(portlet, context, rundata, state);
        }
        Log.warn("chef", (Object)((Object)this) + ".buildMainPanelContext: invalid mode: " + mode);
        return null;
    }

    private String buildFormModeContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("user", UsageSessionService.getSessionUser());
        return (String)this.getContext(rundata).get("template") + "_form";
    }

    private String buildConfirmModeContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        return (String)this.getContext(rundata).get("template") + "_confirm";
    }

    private String buildDocModeContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        return (String)this.getContext(rundata).get("template") + "_doc";
    }

    private String buildExceptionModeContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        return (String)this.getContext(rundata).get("template") + "_exception";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSend(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        String userName = "";
        userName = runData.getParameters().getString("username");
        String displayName = "";
        displayName = runData.getParameters().getString("displayName");
        String comments = "";
        comments = runData.getParameters().getString("comments");
        String email = "";
        email = runData.getParameters().getString("email");
        try {
            String postURL = "http://coursetools.ummu.umich.edu/umctng/helppost.nsf/emailcomments?createdocument";
            URL url = new URL(postURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            Site worksite = SiteService.getSite(PortalService.getCurrentSiteId());
            String creatorId = worksite.getProperties().getProperty("CHEF:creator");
            User creator = UserDirectoryService.getUser(creatorId);
            String content = "CTNG_username=" + URLEncoder.encode(userName) + "&CTNG_displayName=" + URLEncoder.encode(displayName) + "&CTNG_comments=" + URLEncoder.encode(comments) + "&CTNG_email=" + URLEncoder.encode(email) + "&CTNG_IP=" + URLEncoder.encode(UsageSessionService.getSession().getIpAddress()) + "&CTNG_agent=" + URLEncoder.encode(UsageSessionService.getSession().getUserAgent()) + "&CTNG_sessionId=" + URLEncoder.encode(UsageSessionService.getSession().getId()) + "&CTNG_worksiteURL=" + URLEncoder.encode(worksite.getUrl()) + "&CTNG_worksiteTitle=" + URLEncoder.encode(worksite.getTitle()) + "&CTNG_worksiteCreatorUsername=" + URLEncoder.encode(creatorId) + "&CTNG_worksiteCreatorEmail=" + URLEncoder.encode(creator.getEmail());
            Log.debug("chef", "content to be sent is: " + content);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-length", "" + content.length());
            DataOutputStream ostream = new DataOutputStream(conn.getOutputStream());
            ostream.writeBytes(content);
            ostream.close();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            if (br == null) {
                state.setAttribute("mode", (Object)STATE_EXCEPTION);
            } else {
                String line;
                while ((line = br.readLine()) != null) {
                    void var18_21;
                    Log.debug("chef", "response from server" + (String)var18_21);
                }
            }
            br.close();
            conn.disconnect();
            state.setAttribute("mode", (Object)STATE_CONFIRM);
            return;
        }
        catch (MalformedURLException e) {
            Log.debug("chef", "net exception" + e);
            state.setAttribute("mode", (Object)STATE_EXCEPTION);
            return;
        }
        catch (IOException e) {
            Log.debug("chef", "io exception" + e);
            state.setAttribute("mode", (Object)STATE_EXCEPTION);
            return;
        }
        catch (IdUnusedException e) {
            Log.debug("chef", "io exception" + e);
        }
    }

    public void doNew(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute("mode", (Object)STATE_FORM);
    }

    public void doDoc(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute("mode", (Object)STATE_DOC);
    }

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
    }

    static {
        STATE_FORM = STATE_FORM;
        STATE_CONFIRM = STATE_CONFIRM;
        STATE_EXCEPTION = STATE_EXCEPTION;
        STATE_DOC = STATE_DOC;
    }
}

