;;
;; Windows Planner NSIS installer language macros
;;

!macro PLANNER_MACRO_ADD_LANGUAGE LANGUAGE
  !ifndef INSERT_DEFAULT
    !insertmacro MUI_LANGUAGE ${LANGUAGE}
  !endif
!macroend

!macro PLANNER_MACRO_DEFINE_STRING LABEL VALUE
  !ifndef "${LABEL}"
    !define "${LABEL}" "${VALUE}"
    !ifdef INSERT_DEFAULT
      !warning "${LANG} lang file missing ${LABEL}, using default.."
    !endif
  !endif
!macroend

!macro PLANNER_MACRO_LANGSTRING_INSERT LABEL LANG
  LangString "${LABEL}" "${LANG_${LANG}}" "${${LABEL}}"
  !undef "${LABEL}"
!macroend

!macro PLANNER_MACRO_LANGUAGEFILE_BEGIN LANG
  !define CUR_LANG "${LANG}"
!macroend

!macro PLANNER_MACRO_LANGUAGEFILE_END
  !define INSERT_DEFAULT
  !include "${PLANNER_DEFAULT_LANGFILE}"
  !undef INSERT_DEFAULT

  ; PLANNER Language file Version 3
  ; String labels should match those from the default language file.

  ; Startup checks
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT INSTALLER_IS_RUNNING			${CUR_LANG}
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT PLANNER_IS_RUNNING			${CUR_LANG}

  ; License Page
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT PLANNER_LICENSE_BUTTON			${CUR_LANG}
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT PLANNER_LICENSE_BOTTOM_TEXT		${CUR_LANG}

  ; Components Page
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT PLANNER_SECTION_TITLE			${CUR_LANG}
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT PLANNER_TRANSLATIONS_SECTION_TITLE	${CUR_LANG}
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT PLANNER_SECTION_DESCRIPTION		${CUR_LANG}
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT PLANNER_TRANSLATIONS_SECTION_DESCRIPTION	${CUR_LANG}
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT GTK_PRIVATE_SECTION_TITLE		${CUR_LANG}
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT GTK_PRIVATE_SECTION_DESCRIPTION		${CUR_LANG}
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT GTK_PUBLIC_SECTION_TITLE			${CUR_LANG}
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT GTK_PUBLIC_SECTION_DESCRIPTION		${CUR_LANG}

  ; Installer Finish Page
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT PLANNER_FINISH_VISIT_WEB_SITE		${CUR_LANG}

  ; Planner Section Prompts and Texts
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT PLANNER_UNINSTALL_DESC			${CUR_LANG}
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT PLANNER_PROMPT_WIPEOUT			${CUR_LANG}
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT PLANNER_PROMPT_DIR_EXISTS		${CUR_LANG}

  ; Uninstall Section Prompts
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT un.PLANNER_UNINSTALL_ERROR_1		${CUR_LANG}
  !insertmacro PLANNER_MACRO_LANGSTRING_INSERT un.PLANNER_UNINSTALL_ERROR_2		${CUR_LANG}

  !undef CUR_LANG
!macroend

!macro PLANNER_MACRO_INCLUDE_LANGFILE LANG FILE
  !insertmacro PLANNER_MACRO_LANGUAGEFILE_BEGIN "${LANG}"
  !include "${FILE}"
  !insertmacro PLANNER_MACRO_LANGUAGEFILE_END
!macroend
