/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;

/**
 * アンパサンド以外にアンダースコアのニーモニックをサポートする辞書です。
 * <p>
 * @author cypher256
 */
public class UnderscoreMnemonicDictionary extends DynamicTranslationDictionary {

	/**
	 * 翻訳前に _ を & に置換し、翻訳後に & を _ に戻します。
	 */
	@Override
	public String lookup(String enWithMnemonic, JointPoint jointPoint) {

		boolean containsUnderscore =
			pleiadesOption.isUnderscoreMnemonic &&
			enWithMnemonic.contains("_") &&
			!enWithMnemonic.contains("__") &&
			enWithMnemonic.matches(".*_\\w.*")
		;
		if (containsUnderscore) {
			enWithMnemonic = enWithMnemonic.replaceFirst("_", "&");
		}

		String ja = super.lookup(enWithMnemonic, jointPoint);

		if (containsUnderscore) {
			ja = ja.replaceFirst("&", "_");;
		}
		return ja;
	}
}
