# -*- coding: utf-8 -*-

#  Copyright © 2013  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.


cdef extern from 'glm/glm.hpp' namespace "glm":
    cdef cppclass vec3:
        float x, y, z
        vec3()
        vec3(float, float, float)
        
    cdef cppclass vec4:
        float x, y, z, w
        vec4()
        vec4(float, float, float, float)
        float& operator[](int)
        vec4 operator+(vec4)
        vec4 operator*(vec4)
        
    cdef cppclass mat4:
        mat4()
        mat4(float)
        vec4& operator[](int)
        mat4 operator*(mat4)
        vec4 operator*(vec4)
        
cdef extern from 'glm/gtx/transform.hpp' namespace "glm":
    cdef mat4 rotate(float, vec3)
    
    

