'''OpenGL extension NV.vertex_attrib_integer_64bit

This module customises the behaviour of the 
OpenGL.raw.GL.NV.vertex_attrib_integer_64bit to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides support for specifying vertex attributes with
	64-bit integer components, analagous to the 64-bit floating point support
	added in EXT_vertex_attrib_64bit.
	
	Additionally, it provides the VertexAttribLFormatNV entry point to specify
	bindless vertex attribute arrays with 64-bit integer or floating-point
	components in conjunction with the NV_vertex_buffer_unified_memory
	extension.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/vertex_attrib_integer_64bit.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.NV.vertex_attrib_integer_64bit import *
### END AUTOGENERATED SECTION