# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.kusto.aio import KustoManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKustoManagementDataConnectionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KustoManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_connections_list_by_database(self, resource_group):
        response = self.client.data_connections.list_by_database(
            resource_group_name=resource_group.name,
            cluster_name="str",
            database_name="str",
            api_version="2024-04-13",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_connections_begin_data_connection_validation(self, resource_group):
        response = await (
            await self.client.data_connections.begin_data_connection_validation(
                resource_group_name=resource_group.name,
                cluster_name="str",
                database_name="str",
                parameters={"dataConnectionName": "str", "properties": "data_connection"},
                api_version="2024-04-13",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_connections_check_name_availability(self, resource_group):
        response = await self.client.data_connections.check_name_availability(
            resource_group_name=resource_group.name,
            cluster_name="str",
            database_name="str",
            data_connection_name={"name": "str", "type": "Microsoft.Kusto/clusters/databases/dataConnections"},
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_connections_get(self, resource_group):
        response = await self.client.data_connections.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            database_name="str",
            data_connection_name="str",
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_connections_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.data_connections.begin_create_or_update(
                resource_group_name=resource_group.name,
                cluster_name="str",
                database_name="str",
                data_connection_name="str",
                parameters={
                    "kind": "CosmosDb",
                    "cosmosDbAccountResourceId": "str",
                    "cosmosDbContainer": "str",
                    "cosmosDbDatabase": "str",
                    "id": "str",
                    "location": "str",
                    "managedIdentityObjectId": "str",
                    "managedIdentityResourceId": "str",
                    "mappingRuleName": "str",
                    "name": "str",
                    "provisioningState": "str",
                    "retrievalStartDate": "2020-02-20 00:00:00",
                    "tableName": "str",
                    "type": "str",
                },
                api_version="2024-04-13",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_connections_begin_update(self, resource_group):
        response = await (
            await self.client.data_connections.begin_update(
                resource_group_name=resource_group.name,
                cluster_name="str",
                database_name="str",
                data_connection_name="str",
                parameters={
                    "kind": "CosmosDb",
                    "cosmosDbAccountResourceId": "str",
                    "cosmosDbContainer": "str",
                    "cosmosDbDatabase": "str",
                    "id": "str",
                    "location": "str",
                    "managedIdentityObjectId": "str",
                    "managedIdentityResourceId": "str",
                    "mappingRuleName": "str",
                    "name": "str",
                    "provisioningState": "str",
                    "retrievalStartDate": "2020-02-20 00:00:00",
                    "tableName": "str",
                    "type": "str",
                },
                api_version="2024-04-13",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_connections_begin_delete(self, resource_group):
        response = await (
            await self.client.data_connections.begin_delete(
                resource_group_name=resource_group.name,
                cluster_name="str",
                database_name="str",
                data_connection_name="str",
                api_version="2024-04-13",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
