#ifndef CKDTREE_CPP_DECL
#define CKDTREE_CPP_DECL

/*
 * Make sure that these declarations are correct
 * by looking at the header file ckdtree.h which 
 * is generated by running
 *
 * $ cython ckdtree.pyx
 *
 * Unless you add fields to cKDTree there will be 
 * no change in struct ckdtree. The fields are layed
 * out in the same order they are defined in Cython.
 */

struct ckdtreenode {
    npy_intp      split_dim;
    npy_intp      children;
    npy_float64   split;
    npy_intp      start_idx;
    npy_intp      end_idx;
    ckdtreenode   *less;
    ckdtreenode   *greater;
    npy_intp      _less;
    npy_intp      _greater;
};

#ifdef CKDTREE_METHODS_IMPL
struct ckdtree {
    PyObject_HEAD
    // vtab pointer is present as long as cKDTree has cdef methods
    const void          *vtab; 
    // tree structure
    std::vector<ckdtreenode>  *tree_buffer;
    const ckdtreenode   *ctree;
    const PyObject      *dummy;
    // meta data
    const PyArrayObject *data;
    const npy_float64   *raw_data;
    const npy_intp      n;
    const npy_intp      m;
    const npy_intp      leafsize;
    const PyArrayObject *maxes;
    const npy_float64   *raw_maxes;
    const PyArrayObject *mins;
    const npy_float64   *raw_mins;
    const PyArrayObject *indices;
    const npy_intp      *raw_indices;
    const PyArrayObject *_median_workspace;
    const PyObject      *boxsize;
    const PyArrayObject *boxsize_data;
    const npy_float64   *raw_boxsize_data;
    const npy_intp size;
};
#endif
#endif
