# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/).

## [1.5.2] - 2025-12-08

### Added
- Improved debugging functionality (see manpage)

### Fixed
- fd-passing for Python 3.14's ProcessPoolExecutor
- Enhanced debugging for fd types being passed

## [1.5.1] - 2025-05-26

### Added
- Support for SOCKET_WRAPPER_ALLOW_DGRAM_SEQPACKET_FALLBACK

## [1.5.0] - 2025-05-06

### Added
- Support for quic_ko_wrapper

### Fixed
- pcap frames generation for recv(m)msg and recvfrom

## [1.4.4] - 2025-01-21

### Fixed
- setsockopt(SO_REUSEPORT) with glibc 2.40

## [1.4.3] - 2024-06-12

### Fixed
- socket_wrapper running with jemalloc compiled binaries
- Thread sanitizer on modern Linux Kernels
- swrap_fake_uid_wrapper test
- Building on Hurd

## [1.4.2] - 2023-06-29

### Fixed
- LFS issues on 32bit platforms

## [1.4.1] - 2023-06-21

### Added
- openat64() to detect stale fds

### Fixed
- Issue with fnctl() on 32bit

## [1.4.0] - 2023-01-18

### Added
- Support for sendmmsg()/recvmmsg()
- Support for handling close, recvmmsg and sendmmsg syscalls
- Support to interact with uid_wrapper syscall()

### Changed
- Improved IP address tracing output

## [1.3.5] - 2022-11-23

### Added
- Inject O_LARGEFILE as needed on 32bit

### Fixed
- pkgconfig: Fix path to libsocket_wrapper.so
- -Wcast-qual warnings
- dclose(RTLD_NEXT)

## [1.3.4] - 2022-07-21

### Fixed
- TOCTOU issue with udp auto binding
- Running on FreeBSD

## [1.3.3] - 2021-03-17

### Added
- Public libsocket_wrapper_noop library
- Wrapper for wrap __close_nocancel()

### Fixed
- Possible deadlock in swrap_pcap_dump_packet()
- Issue when writing pcap files

## [1.3.2] - 2021-02-10

### Fixed
- Possible memory leak between swrap_recvmsg_{before,after}_unix()

## [1.3.1] - 2021-02-09

### Fixed
- Copy on write leak of ~38M for every fork
- Issue with accept() on FreeBSD
- fd-passing on 32bit platforms
- Invalid read in swrap_sendmsg_unix_scm_rights()

## [1.3.0] - 2021-02-03

### Added
- Support for fd-passing via unix sockets
- (de)contructor support on AIX with pragma init/finish

### Fixed
- Mutex fork handling

## [1.2.5] - 2020-06-22

### Added
- Basic support for TCP_INFO and SIOCOUTQ/TIOCOUTQ/FIONWRITE
- SOCKET_WRAPPER_DIR_ALLOW_ORIG and abort() early if SOCKET_WRAPPER_DIR is unusable

## [1.2.4] - 2020-03-24

### Added
- Support for 10.53.57.0 network
- _{socket,close,connect,...} symbols on FreeBSD

### Fixed
- Interaction with resolv_wrapper on FreeBSD

## [1.2.3] - 2019-03-21

### Fixed
- Missing NULL check for socket_wrapper_dir()
- Building in Samba source tree

## [1.2.2] - 2019-03-21

### Added
- Environment variable to disable deep binding

### Fixed
- Installation of socket_wrapper
- Several small bugs

## [1.2.1] - 2018-11-14

### Removed
- Error message to fix applications doing stupid things

## [1.2.0] - 2018-11-13

### Added
- Threading support

### Changed
- Moved to modern cmake

### Fixed
- Several smaller bugfixes

## [1.1.9] - 2017-12-04

### Fixed
- Thread - signal deadlock issue

## [1.1.8] - 2017-10-13

### Added
- Support for openat()
- Support for open64() and fopen64()
- Always enabled logging support

### Changed
- Increased maximum for wrapped interfaces to 64
- Improved fd duplication code

### Fixed
- Strict-aliasing issues
- Some use after free issues
- Issues on ppc64le

## [1.1.7] - 2016-05-20

### Added
- Support for accept4()
- Support for OpenBSD

### Fixed
- sendto() with UDP and a connected socket
- AF_RAWLINK sockets

## [1.1.6] - 2016-03-15

### Added
- Wrapper for write()
- Support for automatic binding of ephemeral ports

### Fixed
- recvmsg() with UDP
- AF_NETLINK sockets

## [1.1.5] - 2015-10-15

### Added
- Support for TCP_NODELAY in setsockopt/getsockopt

### Fixed
- cmsg space calculation

## [1.1.4] - 2015-08-25

### Added
- Environment variable to change MTU

### Fixed
- Handling of msg_name in recvmsg()
- sendmsg()/recvmsg() TCP support
- Several compile warnings

## [1.1.3] - 2015-02-23

### Added
- Support for address sanitizer

### Fixed
- Leaking of memory and fds of stale sockets
- Library loading code

## [1.1.2] - 2014-10-01

### Added
- Support for fnctl(F_DUPFD)
- Support for glibc 2.20.90

## [1.1.1] - 2014-06-05

### Changed
- Disable incomplete address in use check in bind()

## [1.1.0] - 2014-06-02

### Added
- Support for IP_PKTINFO in recvmsg()
- Support for IPV6_PKTINFO in recvmsg()
- Support for IP_RECVDSTADDR in recvmsg() on BSD
- Support for more socket options in getsockopt()
- Support for bindresvport()

### Fixed
- Rebinding on connect()
- sockaddr buffer truncation in getsockname() and getpeername()
- Special cases in bind()
- Loading libc on some platforms

## [1.0.2] - 2014-05-05

### Fixed
- Memory leaks
- Calling open from libc
- Loading libc functions on some platforms

## [1.0.1] - 2014-02-04

### Added
- --libs to pkg-config
- socket_wrapper-config.cmake

### Fixed
- Bug packaging the obj directory

## [1.0.0] - 2014-02-02

- Initial release
