struct node {
    int value;
    struct node *next;
};

struct stack {
    struct node *head;
};

struct stack *stack_create(void) {
    struct stack *s = malloc(sizeof(struct stack));
    s->head = NULL;
    return s;
}

void stack_push(struct stack *s, int value) {
    struct node *n = malloc(sizeof(struct node));
    n->value = value;

    struct node *head;
    do {
        head = atomic_read(&s->head);
        n->next = head;
    } while (compare_and_swap(&s->head, head, n) != head);
}

int stack_pop(struct stack *s) {
    struct node *head;
    do {
        head = atomic_read(&s->head);
    } while (compare_and_swap(&s->head, head, head->next) != head);

    int result = head->value;
    free(head);
    return result;
}

struct stack *s;

void thread(void) {
    stack_pop(s);
}

int main(void) {
    s = stack_create();
    stack_push(s, 10);
    stack_push(s, 20);

    thread_new(&thread);
    stack_pop(s);

    return 0;
}
