#!/usr/bin/env bats
# Test to check if the LEGACY config settings match
# those shown by ssh and sshd.

setup_file() {
    update-crypto-policies --set LEGACY
}

. ./openssh/shared

@test "LEGACY policy: Client Ciphers match expected" {
    assert_client_ciphers
}
@test "LEGACY policy: Client MACs match expected" {
    assert_client_macs
}
@test "LEGACY policy: Client KEX match expected" {
    assert_client_kex
}
@test "LEGACY policy: Client PubKey match expected" {
    assert_client_pubkey
}
@test "LEGACY policy: Client GSSAPIKex match expected" {
    assert_client_gssapikex
}
@test "LEGACY policy: Client HostBased match expected" {
    assert_client_hostbased
}
@test "LEGACY policy: Client CASignature match expected" {
    assert_client_casignature
}
@test "LEGACY policy: Client RSASize match expected" {
    assert_client_rsasize
}

@test "LEGACY policy: Server Ciphers match expected" {
    assert_server_ciphers
}
@test "LEGACY policy: Server MACs match expected" {
    assert_server_macs
}
@test "LEGACY policy: Server KEX match expected" {
    assert_server_kex
}
@test "LEGACY policy: Server PubKey match expected" {
    assert_server_pubkey
}
@test "LEGACY policy: Server GSSAPIKex match expected" {
    assert_server_gssapikex
}
@test "LEGACY policy: Server HostBased match expected" {
    assert_server_hostbased
}
@test "LEGACY policy: Server CASignature match expected" {
    assert_server_casignature
}
@test "LEGACY policy: Server RSASize match expected" {
    assert_server_rsasize
}

