import * as Primitive from "@ot-builder/primitive";
export declare const Tag = "STAT";
export declare class Axis {
    readonly tag: Primitive.Tag;
    readonly axisNameID: Primitive.UInt16;
    readonly axisOrdering: Primitive.UInt16;
    constructor(tag: Primitive.Tag, axisNameID: Primitive.UInt16, axisOrdering: Primitive.UInt16);
}
export declare enum NameFlags {
    OlderSiblingFontAttribute = 1,
    ElidableAxisValueName = 2
}
export declare class NameAssignment {
    readonly flags: NameFlags;
    readonly valueNameID: Primitive.UInt16;
    constructor(flags: NameFlags, valueNameID: Primitive.UInt16);
}
export declare namespace AxisValue {
    abstract class General {
    }
    class Static extends General {
        readonly axis: Axis;
        readonly value: Primitive.F16D16;
        constructor(axis: Axis, value: Primitive.F16D16);
    }
    class Linked extends General {
        readonly axis: Axis;
        readonly value: Primitive.F16D16;
        readonly linkedValue: Primitive.F16D16;
        constructor(axis: Axis, value: Primitive.F16D16, linkedValue: Primitive.F16D16);
    }
    class Variable extends General {
        readonly axis: Axis;
        readonly min: Primitive.F16D16;
        readonly nominal: Primitive.F16D16;
        readonly max: Primitive.F16D16;
        constructor(axis: Axis, min: Primitive.F16D16, nominal: Primitive.F16D16, max: Primitive.F16D16);
    }
    class PolyAxis extends General {
        readonly assignments: [Axis, Primitive.F16D16][];
        constructor(assignments: [Axis, Primitive.F16D16][]);
    }
}
export declare class Table {
    designAxes: Axis[];
    assignments: Array<[AxisValue.General, NameAssignment]>;
    elidedFallbackNameID: Primitive.UInt16;
    constructor(designAxes?: Axis[], assignments?: Array<[AxisValue.General, NameAssignment]>, elidedFallbackNameID?: Primitive.UInt16);
}
//# sourceMappingURL=stat.d.ts.map