; RUN: opt -O2 %s | llvm-dis > %t1
; RUN: llc -filetype=asm -o - %t1 | FileCheck %s
; RUN: llc -mattr=+alu32 -filetype=asm -o - %t1 | FileCheck %s
;
; Source code:
;   typedef const int arr_t[7];
;   typedef arr_t __arr;
;   typedef __arr _arr;
;   struct __s { _arr a; };
;   typedef struct __s s;
;   #define _(x) (__builtin_preserve_access_index(x))
;   int get_value(const ptr addr);
;   int test(s *arg) {
;     return get_value(_(&arg->a[1]));
;   }
; clang -target bpf -S -O2 -g -emit-llvm -Xclang -disable-llvm-passes test.c

target triple = "bpf"

%struct.__s = type { [7 x i32] }

; Function Attrs: nounwind
define dso_local i32 @test(ptr %arg) local_unnamed_addr !dbg !7 {
entry:
  call void @llvm.dbg.value(metadata ptr %arg, metadata !24, metadata !DIExpression()), !dbg !25
  %0 = tail call ptr @llvm.preserve.struct.access.index.p0.p0.__ss(ptr elementtype(%struct.__s) %arg, i32 0, i32 0), !dbg !26, !llvm.preserve.access.index !13
  %1 = tail call ptr @llvm.preserve.array.access.index.p0.p0(ptr elementtype([7 x i32]) %0, i32 1, i32 1), !dbg !26, !llvm.preserve.access.index !19
  %call = tail call i32 @get_value(ptr %1), !dbg !27
  ret i32 %call, !dbg !28
}

; CHECK:        .cfi_startproc
; CHECK: [[RELOC:.Ltmp[0-9]+]]:
; CHECK:         r2 = 4
; CHECK:         r1 += r2
; CHECK:         call get_value

; CHECK:         .long   {{[0-9]+}}              # BTF_KIND_STRUCT(id = [[TYPE_ID:[0-9]+]])
; CHECK:         .ascii  ".text"                 # string offset=[[SEC_INDEX:[0-9]+]]
; CHECK-NEXT:    .byte   0
; CHECK:         .ascii  "0:0:1"                 # string offset=[[ACCESS_STR:[0-9]+]]
; CHECK-NEXT:    .byte   0
; CHECK:         .long   16                      # FieldReloc
; CHECK-NEXT:    .long   [[SEC_INDEX]]           # Field reloc section string offset=[[SEC_INDEX]]
; CHECK-NEXT:    .long   1
; CHECK-NEXT:    .long   [[RELOC]]
; CHECK-NEXT:    .long   [[TYPE_ID]]
; CHECK-NEXT:    .long   [[ACCESS_STR]]
; CHECK-NEXT:    .long   0

declare dso_local i32 @get_value(ptr) local_unnamed_addr

; Function Attrs: nounwind readnone
declare ptr @llvm.preserve.struct.access.index.p0.p0.__ss(ptr, i32 immarg, i32 immarg)

; Function Attrs: nounwind readnone
declare ptr @llvm.preserve.array.access.index.p0.p0(ptr, i32 immarg, i32 immarg)

; Function Attrs: nounwind readnone speculatable
declare void @llvm.dbg.value(metadata, metadata, metadata)

!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!3, !4, !5}
!llvm.ident = !{!6}

!0 = distinct !DICompileUnit(language: DW_LANG_C99, file: !1, producer: "clang version 10.0.0 (trunk 366831) (llvm/trunk 366867)", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !2, nameTableKind: None)
!1 = !DIFile(filename: "test.c", directory: "/tmp/home/yhs/work/tests/llvm/core-bugs")
!2 = !{}
!3 = !{i32 2, !"Dwarf Version", i32 4}
!4 = !{i32 2, !"Debug Info Version", i32 3}
!5 = !{i32 1, !"wchar_size", i32 4}
!6 = !{!"clang version 10.0.0 (trunk 366831) (llvm/trunk 366867)"}
!7 = distinct !DISubprogram(name: "test", scope: !1, file: !1, line: 8, type: !8, scopeLine: 8, flags: DIFlagPrototyped, isDefinition: true, isOptimized: true, unit: !0, retainedNodes: !23)
!8 = !DISubroutineType(types: !9)
!9 = !{!10, !11}
!10 = !DIBasicType(name: "int", size: 32, encoding: DW_ATE_signed)
!11 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !12, size: 64)
!12 = !DIDerivedType(tag: DW_TAG_typedef, name: "s", file: !1, line: 5, baseType: !13)
!13 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "__s", file: !1, line: 4, size: 224, elements: !14)
!14 = !{!15}
!15 = !DIDerivedType(tag: DW_TAG_member, name: "a", scope: !13, file: !1, line: 4, baseType: !16, size: 224)
!16 = !DIDerivedType(tag: DW_TAG_typedef, name: "_arr", file: !1, line: 3, baseType: !17)
!17 = !DIDerivedType(tag: DW_TAG_typedef, name: "__arr", file: !1, line: 2, baseType: !18)
!18 = !DIDerivedType(tag: DW_TAG_typedef, name: "arr_t", file: !1, line: 1, baseType: !19)
!19 = !DICompositeType(tag: DW_TAG_array_type, baseType: !20, size: 224, elements: !21)
!20 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !10)
!21 = !{!22}
!22 = !DISubrange(count: 7)
!23 = !{!24}
!24 = !DILocalVariable(name: "arg", arg: 1, scope: !7, file: !1, line: 8, type: !11)
!25 = !DILocation(line: 0, scope: !7)
!26 = !DILocation(line: 9, column: 20, scope: !7)
!27 = !DILocation(line: 9, column: 10, scope: !7)
!28 = !DILocation(line: 9, column: 3, scope: !7)
